/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityContainerInfo;
import com.hubspot.singularity.HealthcheckProtocol;
import com.hubspot.singularity.JsonHelpers;
import com.hubspot.singularity.SingularityDeployBuilder;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingularityDeploy {
    private final String requestId;
    private final String id;
    private final Optional<String> version;
    private final Optional<Long> timestamp;
    private final Optional<Map<String, String>> metadata;
    private final Optional<SingularityContainerInfo> containerInfo;
    private final Optional<String> customExecutorCmd;
    private final Optional<String> customExecutorId;
    private final Optional<String> customExecutorSource;
    private final Optional<Resources> customExecutorResources;
    private final Optional<String> customExecutorUser;
    private final Optional<Resources> resources;
    private final Optional<String> command;
    private final Optional<List<String>> arguments;
    private final Optional<Map<String, String>> env;
    private final Optional<List<String>> uris;
    private final Optional<ExecutorData> executorData;
    private final Optional<Map<String, String>> labels;
    private final Optional<String> healthcheckUri;
    private final Optional<Long> healthcheckIntervalSeconds;
    private final Optional<Long> healthcheckTimeoutSeconds;
    private final Optional<Integer> healthcheckPortIndex;
    private final Optional<Boolean> skipHealthchecksOnDeploy;
    private final Optional<HealthcheckProtocol> healthcheckProtocol;
    private final Optional<Integer> healthcheckMaxRetries;
    private final Optional<Long> healthcheckMaxTotalTimeoutSeconds;
    private final Optional<Long> deployHealthTimeoutSeconds;
    private final Optional<Long> considerHealthyAfterRunningForSeconds;
    private final Optional<String> serviceBasePath;
    private final Optional<Set<String>> loadBalancerGroups;
    private final Optional<Integer> loadBalancerPortIndex;
    private final Optional<Map<String, Object>> loadBalancerOptions;

    public static SingularityDeployBuilder newBuilder(String requestId, String id) {
        return new SingularityDeployBuilder(requestId, id);
    }

    @JsonCreator
    public SingularityDeploy(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="id") String id, @JsonProperty(value="command") Optional<String> command, @JsonProperty(value="arguments") Optional<List<String>> arguments, @JsonProperty(value="containerInfo") Optional<SingularityContainerInfo> containerInfo, @JsonProperty(value="customExecutorCmd") Optional<String> customExecutorCmd, @JsonProperty(value="customExecutorId") Optional<String> customExecutorId, @JsonProperty(value="customExecutorSource") Optional<String> customExecutorSource, @JsonProperty(value="customExecutorResources") Optional<Resources> customExecutorResources, @JsonProperty(value="customExecutorUser") Optional<String> customExecutorUser, @JsonProperty(value="resources") Optional<Resources> resources, @JsonProperty(value="env") Optional<Map<String, String>> env, @JsonProperty(value="uris") Optional<List<String>> uris, @JsonProperty(value="metadata") Optional<Map<String, String>> metadata, @JsonProperty(value="executorData") Optional<ExecutorData> executorData, @JsonProperty(value="version") Optional<String> version, @JsonProperty(value="timestamp") Optional<Long> timestamp, @JsonProperty(value="labels") Optional<Map<String, String>> labels, @JsonProperty(value="deployHealthTimeoutSeconds") Optional<Long> deployHealthTimeoutSeconds, @JsonProperty(value="healthcheckUri") Optional<String> healthcheckUri, @JsonProperty(value="healthcheckIntervalSeconds") Optional<Long> healthcheckIntervalSeconds, @JsonProperty(value="healthcheckTimeoutSeconds") Optional<Long> healthcheckTimeoutSeconds, @JsonProperty(value="healthcheckPortIndex") Optional<Integer> healthcheckPortIndex, @JsonProperty(value="healthcheckMaxRetries") Optional<Integer> healthcheckMaxRetries, @JsonProperty(value="healthcheckMaxTotalTimeoutSeconds") Optional<Long> healthcheckMaxTotalTimeoutSeconds, @JsonProperty(value="serviceBasePath") Optional<String> serviceBasePath, @JsonProperty(value="loadBalancerGroups") Optional<Set<String>> loadBalancerGroups, @JsonProperty(value="loadBalancerPortIndex") Optional<Integer> loadBalancerPortIndex, @JsonProperty(value="considerHealthyAfterRunningForSeconds") Optional<Long> considerHealthyAfterRunningForSeconds, @JsonProperty(value="loadBalancerOptions") Optional<Map<String, Object>> loadBalancerOptions, @JsonProperty(value="skipHealthchecksOnDeploy") Optional<Boolean> skipHealthchecksOnDeploy, @JsonProperty(value="healthCheckProtocol") Optional<HealthcheckProtocol> healthcheckProtocol) {
        this.requestId = requestId;
        this.command = command;
        this.arguments = arguments;
        this.resources = resources;
        this.containerInfo = containerInfo;
        this.customExecutorCmd = customExecutorCmd;
        this.customExecutorId = customExecutorId;
        this.customExecutorSource = customExecutorSource;
        this.customExecutorResources = customExecutorResources;
        this.customExecutorUser = customExecutorUser;
        this.metadata = metadata;
        this.version = version;
        this.id = id;
        this.timestamp = timestamp;
        this.env = env;
        this.uris = uris;
        this.executorData = executorData;
        this.labels = labels;
        this.healthcheckUri = healthcheckUri;
        this.healthcheckIntervalSeconds = healthcheckIntervalSeconds;
        this.healthcheckTimeoutSeconds = healthcheckTimeoutSeconds;
        this.healthcheckPortIndex = healthcheckPortIndex;
        this.skipHealthchecksOnDeploy = skipHealthchecksOnDeploy;
        this.healthcheckProtocol = healthcheckProtocol;
        this.healthcheckMaxRetries = healthcheckMaxRetries;
        this.healthcheckMaxTotalTimeoutSeconds = healthcheckMaxTotalTimeoutSeconds;
        this.considerHealthyAfterRunningForSeconds = considerHealthyAfterRunningForSeconds;
        this.deployHealthTimeoutSeconds = deployHealthTimeoutSeconds;
        this.serviceBasePath = serviceBasePath;
        this.loadBalancerGroups = loadBalancerGroups;
        this.loadBalancerPortIndex = loadBalancerPortIndex;
        this.loadBalancerOptions = loadBalancerOptions;
    }

    public SingularityDeployBuilder toBuilder() {
        return new SingularityDeployBuilder(this.requestId, this.id).setCommand(this.command).setArguments(JsonHelpers.copyOfList(this.arguments)).setResources(this.resources).setContainerInfo(this.containerInfo).setCustomExecutorCmd(this.customExecutorCmd).setCustomExecutorId(this.customExecutorId).setCustomExecutorSource(this.customExecutorSource).setCustomExecutorResources(this.customExecutorResources).setCustomExecutorUser(this.customExecutorUser).setHealthcheckUri(this.healthcheckUri).setHealthcheckIntervalSeconds(this.healthcheckIntervalSeconds).setHealthcheckTimeoutSeconds(this.healthcheckTimeoutSeconds).setHealthcheckPortIndex(this.healthcheckPortIndex).setSkipHealthchecksOnDeploy(this.skipHealthchecksOnDeploy).setHealthcheckProtocol(this.healthcheckProtocol).setHealthcheckMaxRetries(this.healthcheckMaxRetries).setHealthcheckMaxTotalTimeoutSeconds(this.healthcheckMaxTotalTimeoutSeconds).setConsiderHealthyAfterRunningForSeconds(this.considerHealthyAfterRunningForSeconds).setDeployHealthTimeoutSeconds(this.deployHealthTimeoutSeconds).setServiceBasePath(this.serviceBasePath).setLoadBalancerGroups(JsonHelpers.copyOfSet(this.loadBalancerGroups)).setLoadBalancerPortIndex(this.loadBalancerPortIndex).setLoadBalancerOptions(JsonHelpers.copyOfMap(this.loadBalancerOptions)).setMetadata(JsonHelpers.copyOfMap(this.metadata)).setVersion(this.version).setTimestamp(this.timestamp).setEnv(JsonHelpers.copyOfMap(this.env)).setUris(JsonHelpers.copyOfList(this.uris)).setExecutorData(this.executorData).setLabels(this.labels);
    }

    @ApiModelProperty(required=false, value="Number of seconds that Singularity waits for this service to become healthy (for it to download artifacts, start running, and optionally pass healthchecks.)")
    public Optional<Long> getDeployHealthTimeoutSeconds() {
        return this.deployHealthTimeoutSeconds;
    }

    @ApiModelProperty(required=true, value="Singularity Request Id which is associated with this deploy.")
    public String getRequestId() {
        return this.requestId;
    }

    @ApiModelProperty(required=true, value="Singularity deploy id.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(required=false, value="Deploy version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @ApiModelProperty(required=false, value="Deploy timestamp.")
    public Optional<Long> getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(required=false, value="Map of metadata key/value pairs associated with the deployment.")
    public Optional<Map<String, String>> getMetadata() {
        return this.metadata;
    }

    @ApiModelProperty(required=false, value="Container information for deployment into a container.", dataType="SingularityContainerInfo")
    public Optional<SingularityContainerInfo> getContainerInfo() {
        return this.containerInfo;
    }

    @ApiModelProperty(required=false, value="Custom Mesos executor", dataType="string")
    public Optional<String> getCustomExecutorCmd() {
        return this.customExecutorCmd;
    }

    @ApiModelProperty(required=false, value="Custom Mesos executor id.")
    public Optional<String> getCustomExecutorId() {
        return this.customExecutorId;
    }

    @ApiModelProperty(required=false, value="Custom Mesos executor source.")
    public Optional<String> getCustomExecutorSource() {
        return this.customExecutorSource;
    }

    @ApiModelProperty(required=false, value="Resources to allocate for custom mesos executor")
    public Optional<Resources> getCustomExecutorResources() {
        return this.customExecutorResources;
    }

    @Deprecated
    @ApiModelProperty(required=false, value="User to run custom executor as")
    public Optional<String> getCustomExecutorUser() {
        return this.customExecutorUser;
    }

    @ApiModelProperty(required=false, value="Resources required for this deploy.", dataType="com.hubspot.mesos.Resources")
    public Optional<Resources> getResources() {
        return this.resources;
    }

    @ApiModelProperty(required=false, value="Command to execute for this deployment.")
    public Optional<String> getCommand() {
        return this.command;
    }

    @ApiModelProperty(required=false, value="Command arguments.")
    public Optional<List<String>> getArguments() {
        return this.arguments;
    }

    @ApiModelProperty(required=false, value="Map of environment variable definitions.")
    public Optional<Map<String, String>> getEnv() {
        return this.env;
    }

    @ApiModelProperty(required=false, value="List of URIs to download before executing the deploy command.")
    public Optional<List<String>> getUris() {
        return this.uris;
    }

    @ApiModelProperty(required=false, value="Executor specific information")
    public Optional<ExecutorData> getExecutorData() {
        return this.executorData;
    }

    @ApiModelProperty(required=false, value="Deployment Healthcheck URI, if specified will be called after TASK_RUNNING.")
    public Optional<String> getHealthcheckUri() {
        return this.healthcheckUri;
    }

    @ApiModelProperty(required=false, value="Healthcheck protocol - HTTP or HTTPS")
    public Optional<HealthcheckProtocol> getHealthcheckProtocol() {
        return this.healthcheckProtocol;
    }

    @ApiModelProperty(required=false, value="Time to wait after a failed healthcheck to try again in seconds.")
    public Optional<Long> getHealthcheckIntervalSeconds() {
        return this.healthcheckIntervalSeconds;
    }

    @ApiModelProperty(required=false, value="Single healthcheck HTTP timeout in seconds.")
    public Optional<Long> getHealthcheckTimeoutSeconds() {
        return this.healthcheckTimeoutSeconds;
    }

    @ApiModelProperty(required=false, value="Perform healthcheck on this dynamically allocated port (e.g. 0 for first port), defaults to first port")
    public Optional<Integer> getHealthcheckPortIndex() {
        return this.healthcheckPortIndex;
    }

    @ApiModelProperty(required=false, value="The base path for the API exposed by the deploy. Used in conjunction with the Load balancer API.")
    public Optional<String> getServiceBasePath() {
        return this.serviceBasePath;
    }

    @ApiModelProperty(required=false, value="Number of seconds that a service must be healthy to consider the deployment to be successful.")
    public Optional<Long> getConsiderHealthyAfterRunningForSeconds() {
        return this.considerHealthyAfterRunningForSeconds;
    }

    @ApiModelProperty(required=false, value="List of load balancer groups associated with this deployment.")
    public Optional<Set<String>> getLoadBalancerGroups() {
        return this.loadBalancerGroups;
    }

    @ApiModelProperty(required=false, value="Send this port to the load balancer api (e.g. 0 for first port), defaults to first port")
    public Optional<Integer> getLoadBalancerPortIndex() {
        return this.loadBalancerPortIndex;
    }

    @ApiModelProperty(required=false, value="Map (Key/Value) of options for the load balancer.")
    public Optional<Map<String, Object>> getLoadBalancerOptions() {
        return this.loadBalancerOptions;
    }

    @ApiModelProperty(required=false, value="Labels for tasks associated with this deploy")
    public Optional<Map<String, String>> getLabels() {
        return this.labels;
    }

    @ApiModelProperty(required=false, value="Allows skipping of health checks when deploying.")
    public Optional<Boolean> getSkipHealthchecksOnDeploy() {
        return this.skipHealthchecksOnDeploy;
    }

    @ApiModelProperty(required=false, value="Maximum number of times to retry an individual healthcheck before failing the deploy.")
    public Optional<Integer> getHealthcheckMaxRetries() {
        return this.healthcheckMaxRetries;
    }

    @ApiModelProperty(required=false, value="Maximum amount of time to wait before failing a deploy for healthchecks to pass.")
    public Optional<Long> getHealthcheckMaxTotalTimeoutSeconds() {
        return this.healthcheckMaxTotalTimeoutSeconds;
    }

    public String toString() {
        return "SingularityDeploy{requestId='" + this.requestId + '\'' + ", id='" + this.id + '\'' + ", version=" + this.version + ", timestamp=" + this.timestamp + ", metadata=" + this.metadata + ", containerInfo=" + this.containerInfo + ", customExecutorCmd=" + this.customExecutorCmd + ", customExecutorId=" + this.customExecutorId + ", customExecutorSource=" + this.customExecutorSource + ", customExecutorResources=" + this.customExecutorResources + ", customExecutorUser=" + this.customExecutorUser + ", resources=" + this.resources + ", command=" + this.command + ", arguments=" + this.arguments + ", env=" + this.env + ", uris=" + this.uris + ", executorData=" + this.executorData + ", healthcheckUri=" + this.healthcheckUri + ", healthcheckIntervalSeconds=" + this.healthcheckIntervalSeconds + ", healthcheckTimeoutSeconds=" + this.healthcheckTimeoutSeconds + ", healthcheckPortIndex=" + this.healthcheckPortIndex + ", skipHealthchecksOnDeploy=" + this.skipHealthchecksOnDeploy + ", healthcheckProtocol=" + this.healthcheckProtocol + ", healthcheckMaxRetries=" + this.healthcheckMaxRetries + ", healthcheckMaxTotalTimeoutSeconds=" + this.healthcheckMaxTotalTimeoutSeconds + ", deployHealthTimeoutSeconds=" + this.deployHealthTimeoutSeconds + ", considerHealthyAfterRunningForSeconds=" + this.considerHealthyAfterRunningForSeconds + ", serviceBasePath=" + this.serviceBasePath + ", loadBalancerGroups=" + this.loadBalancerGroups + ", loadBalancerPortIndex=" + this.loadBalancerPortIndex + ", loadBalancerOptions=" + this.loadBalancerOptions + ", labels=" + this.labels + '}';
    }
}

