/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CounterMap<K> {
    private final Map<K, Counter> map;

    public CounterMap() {
        this.map = new HashMap<K, Counter>();
    }

    public CounterMap(int initialCapacity) {
        this.map = new HashMap<K, Counter>(initialCapacity);
    }

    public Map<K, Long> toCountMap() {
        HashMap<K, Long> result = Maps.newHashMapWithExpectedSize(this.map.size());
        for (Map.Entry<K, Counter> entry : this.map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().count);
        }
        return result;
    }

    public void incr(K key, long amount) {
        Counter c = this.map.get(key);
        if (c == null) {
            c = new Counter();
            this.map.put(key, c);
        }
        Counter counter = c;
        counter.count = counter.count + amount;
    }

    public void incr(K key) {
        this.incr(key, 1L);
    }

    public long getCount(K key) {
        Counter c = this.map.get(key);
        if (c == null) {
            return 0L;
        }
        return c.count;
    }

    public Collection<K> getKeys() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public List<Map.Entry<K, Counter>> asSortedEntryList() {
        ArrayList<Map.Entry<K, Counter>> entries = new ArrayList<Map.Entry<K, Counter>>(this.map.size());
        for (Map.Entry<K, Counter> entry : this.map.entrySet()) {
            entries.add(entry);
        }
        Collections.sort(entries, new Comparator<Map.Entry<K, Counter>>(){

            @Override
            public int compare(Map.Entry<K, Counter> o1, Map.Entry<K, Counter> o2) {
                return Longs.compare(o2.getValue().getCount(), o1.getValue().getCount());
            }
        });
        return entries;
    }

    public String toString() {
        return "CounterMap [map=" + this.map + "]";
    }

    public static final class Counter {
        private long count = 0L;

        private Counter() {
        }

        public long getCount() {
            return this.count;
        }

        public String toString() {
            return "Counter [count=" + this.count + "]";
        }
    }
}

