/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Artifact {
    private final String name;
    private final String filename;
    private final Optional<String> md5sum;

    public Artifact(String name, String filename, Optional<String> md5sum) {
        this.name = name;
        this.filename = filename;
        this.md5sum = md5sum;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public Optional<String> getMd5sum() {
        return this.md5sum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.md5sum == null ? 0 : this.md5sum.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.md5sum == null ? other.md5sum != null : !this.md5sum.equals(other.md5sum)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Artifact [name=" + this.name + ", filename=" + this.filename + ", md5sum=" + this.md5sum + "]";
    }
}

