/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QueuedRequestId {
    private final String serviceId;
    private final String requestId;
    private final int index;

    public static QueuedRequestId fromString(String value) {
        String[] splits = value.split("\\|", 3);
        return new QueuedRequestId(splits[0], splits[1], Integer.parseInt(splits[2]));
    }

    @JsonCreator
    public QueuedRequestId(@JsonProperty(value="serviceId") String serviceId, @JsonProperty(value="requestId") String requestId, @JsonProperty(value="index") int index) {
        this.serviceId = serviceId;
        this.requestId = requestId;
        this.index = index;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getIndex() {
        return this.index;
    }

    @JsonIgnore
    public String buildZkPath() {
        return String.format("%s|%s|%010d", this.serviceId, this.requestId, this.index);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("serviceId", this.serviceId).add("requestId", this.requestId).add("index", this.index).toString();
    }
}

