/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonServiceStatus {
    private final boolean leader;
    private final int pendingRequestCount;
    private final long workerLagMs;
    private final long elbWorkerLagMs;
    private final String zookeeperState;
    private final int globalStateNodeSize;

    @JsonCreator
    public BaragonServiceStatus(@JsonProperty(value="leader") boolean leader, @JsonProperty(value="pendingRequestCount") int pendingRequestCount, @JsonProperty(value="workerLagMs") long workerLagMs, @JsonProperty(value="elbWorkerLagMs") long elbWorkerLagMs, @JsonProperty(value="zookeeperState") String zookeeperState, @JsonProperty(value="globalStateNodeSize") int globalStateNodeSize) {
        this.leader = leader;
        this.pendingRequestCount = pendingRequestCount;
        this.workerLagMs = workerLagMs;
        this.elbWorkerLagMs = elbWorkerLagMs;
        this.zookeeperState = zookeeperState;
        this.globalStateNodeSize = globalStateNodeSize;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public int getPendingRequestCount() {
        return this.pendingRequestCount;
    }

    public long getWorkerLagMs() {
        return this.workerLagMs;
    }

    public long getElbWorkerLagMs() {
        return this.elbWorkerLagMs;
    }

    public String getZookeeperState() {
        return this.zookeeperState;
    }

    public long getGlobalStateNodeSize() {
        return this.globalStateNodeSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonServiceStatus that = (BaragonServiceStatus)o;
        if (this.leader != that.leader) {
            return false;
        }
        if (this.pendingRequestCount != that.pendingRequestCount) {
            return false;
        }
        if (this.workerLagMs != that.workerLagMs) {
            return false;
        }
        if (this.elbWorkerLagMs != that.elbWorkerLagMs) {
            return false;
        }
        return this.zookeeperState.equals(that.zookeeperState);
    }

    public int hashCode() {
        int result = this.leader ? 1 : 0;
        result = 31 * result + this.pendingRequestCount;
        result = 31 * result + (int)(this.workerLagMs ^ this.workerLagMs >>> 32);
        result = 31 * result + (int)(this.elbWorkerLagMs ^ this.elbWorkerLagMs >>> 32);
        result = 31 * result + this.zookeeperState.hashCode();
        result = 31 * result + this.globalStateNodeSize;
        return result;
    }

    public String toString() {
        return "BaragonServiceStatus [leader=" + this.leader + ", pendingRequestCount=" + this.pendingRequestCount + ", workerLagMs=" + this.workerLagMs + ",  elbWorkerLagMs=" + this.elbWorkerLagMs + ", zookeeperState='" + this.zookeeperState + '\'' + ", globalStateNodeSize='" + this.globalStateNodeSize + '\'' + ']';
    }
}

