/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonGroup {
    private final String name;
    private Optional<String> domain;
    private Set<String> sources;

    @JsonCreator
    public BaragonGroup(@JsonProperty(value="name") String name, @JsonProperty(value="domain") Optional<String> domain, @JsonProperty(value="sources") Set<String> sources) {
        this.name = name;
        this.domain = domain;
        this.sources = sources;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDomain() {
        return this.domain;
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public void addSource(String source) {
        this.sources.add(source);
    }

    public void removeSource(String source) {
        this.sources.remove(source);
    }

    public void setDomain(Optional<String> domain) {
        this.domain = domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonGroup that = (BaragonGroup)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.domain.equals(that.domain)) {
            return false;
        }
        return this.sources.equals(that.sources);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + this.sources.hashCode();
        return result;
    }

    public String toString() {
        return "ElbGroup [name=" + this.name + ", domain=" + this.domain + ", sources" + this.sources + ']';
    }
}

