/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;

public class MethodHelper
implements Helper<Object> {
    private Object source;
    private Method method;

    public MethodHelper(Method method, Object source) {
        this.method = Validate.notNull(method, "A helper method is required.", new Object[0]);
        this.source = source;
    }

    @Override
    public CharSequence apply(Object context, Options options) throws IOException {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        int pidx = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            Object arg;
            Class<?> paramType = paramTypes[i];
            Object ctx = i == 0 ? context : null;
            Options opts = i == paramTypes.length - 1 ? options : null;
            Object candidate = options.param(pidx, null);
            args[i] = arg = this.argument(paramType, candidate, ctx, opts);
            if (candidate != arg) continue;
            ++pidx;
        }
        try {
            return (CharSequence)this.method.invoke(this.source, args);
        }
        catch (InvocationTargetException ex) {
            throw this.launderThrowable(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("could not execute helper: " + this.method.getName(), ex);
        }
    }

    private RuntimeException launderThrowable(Throwable cause) throws IOException {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        return new IllegalStateException("could not execute helper: " + this.method.getName(), cause);
    }

    private Object argument(Class<?> paramType, Object argument, Object context, Options options) {
        for (Object candidate : new Object[]{context, argument, options}) {
            if (!paramType.isInstance(candidate) && !MethodHelper.wrap(paramType).isInstance(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private static Class<?> wrap(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
        }
        return type;
    }
}

