/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.helper.I18nSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.Validate;

class DefI18nSource
implements I18nSource {
    private ResourceBundle bundle;

    public DefI18nSource(String baseName, Locale locale, ClassLoader classLoader) {
        this.bundle = ResourceBundle.getBundle(baseName, locale, classLoader);
    }

    @Override
    public String[] keys(String basename, Locale locale) {
        Enumeration<String> keys = this.bundle.getKeys();
        ArrayList<String> result = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String message(String key, Locale locale, Object ... args) {
        Validate.isTrue(this.bundle.containsKey(key), "no message found: '%s' for locale '%s'.", key, locale);
        String message = this.bundle.getString(key);
        if (args.length == 0) {
            return message;
        }
        MessageFormat format = new MessageFormat(message, locale);
        return format.format(args);
    }
}

