/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import java.io.IOException;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class PeriodDeserializer
extends JodaDeserializerBase<ReadablePeriod> {
    private static final long serialVersionUID = 1L;
    private static final PeriodFormatter DEFAULT_FORMAT = ISOPeriodFormat.standard();
    private final boolean _requireFullPeriod;

    public PeriodDeserializer() {
        this(true);
    }

    public PeriodDeserializer(boolean fullPeriod) {
        super(fullPeriod ? Period.class : ReadablePeriod.class);
        this._requireFullPeriod = fullPeriod;
    }

    @Override
    public ReadablePeriod deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ReadablePeriod p;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.isEmpty()) {
                return null;
            }
            return DEFAULT_FORMAT.parsePeriod(str);
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Period(jp.getLongValue());
        }
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Number, String or Object");
        }
        JsonNode treeNode = (JsonNode)jp.readValueAsTree();
        String periodType = treeNode.path("fieldType").path("name").asText();
        String periodName = treeNode.path("periodType").path("name").asText();
        int periodValue = treeNode.path(periodType).asInt();
        if (periodName.equals("Seconds")) {
            p = Seconds.seconds(periodValue);
        } else if (periodName.equals("Minutes")) {
            p = Minutes.minutes(periodValue);
        } else if (periodName.equals("Hours")) {
            p = Hours.hours(periodValue);
        } else if (periodName.equals("Days")) {
            p = Days.days(periodValue);
        } else if (periodName.equals("Weeks")) {
            p = Weeks.weeks(periodValue);
        } else if (periodName.equals("Months")) {
            p = Months.months(periodValue);
        } else if (periodName.equals("Years")) {
            p = Years.years(periodValue);
        } else {
            throw ctxt.mappingException("Don't know how to deserialize " + this.handledType().getName() + " using periodName '" + periodName + "'");
        }
        if (this._requireFullPeriod && !(p instanceof Period)) {
            p = p.toPeriod();
        }
        return p;
    }
}

