/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.validation.Constraint;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import org.hibernate.validator.constraints.ConstraintComposition;
import org.hibernate.validator.constraints.Currency;
import org.hibernate.validator.constraints.EAN;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.LuhnCheck;
import org.hibernate.validator.constraints.Mod10Check;
import org.hibernate.validator.constraints.Mod11Check;
import org.hibernate.validator.constraints.ModCheck;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.ParameterScriptAssert;
import org.hibernate.validator.constraints.SafeHtml;
import org.hibernate.validator.constraints.ScriptAssert;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.constraints.br.CNPJ;
import org.hibernate.validator.constraints.br.CPF;
import org.hibernate.validator.constraints.pl.NIP;
import org.hibernate.validator.constraints.pl.PESEL;
import org.hibernate.validator.constraints.pl.REGON;
import org.hibernate.validator.internal.constraintvalidators.bv.AssertFalseValidator;
import org.hibernate.validator.internal.constraintvalidators.bv.AssertTrueValidator;
import org.hibernate.validator.internal.constraintvalidators.bv.DecimalMaxValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.bv.DecimalMaxValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.bv.DecimalMinValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.bv.DecimalMinValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.bv.DigitsValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.bv.MaxValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.bv.MaxValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.bv.MinValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.bv.MinValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.bv.NotNullValidator;
import org.hibernate.validator.internal.constraintvalidators.bv.NullValidator;
import org.hibernate.validator.internal.constraintvalidators.bv.PatternValidator;
import org.hibernate.validator.internal.constraintvalidators.bv.future.FutureValidatorForCalendar;
import org.hibernate.validator.internal.constraintvalidators.bv.future.FutureValidatorForChronoZonedDateTime;
import org.hibernate.validator.internal.constraintvalidators.bv.future.FutureValidatorForDate;
import org.hibernate.validator.internal.constraintvalidators.bv.future.FutureValidatorForInstant;
import org.hibernate.validator.internal.constraintvalidators.bv.future.FutureValidatorForOffsetDateTime;
import org.hibernate.validator.internal.constraintvalidators.bv.future.FutureValidatorForReadableInstant;
import org.hibernate.validator.internal.constraintvalidators.bv.future.FutureValidatorForReadablePartial;
import org.hibernate.validator.internal.constraintvalidators.bv.money.CurrencyValidatorForMonetaryAmount;
import org.hibernate.validator.internal.constraintvalidators.bv.money.DecimalMaxValidatorForMonetaryAmount;
import org.hibernate.validator.internal.constraintvalidators.bv.money.DecimalMinValidatorForMonetaryAmount;
import org.hibernate.validator.internal.constraintvalidators.bv.money.MaxValidatorForMonetaryAmount;
import org.hibernate.validator.internal.constraintvalidators.bv.money.MinValidatorForMonetaryAmount;
import org.hibernate.validator.internal.constraintvalidators.bv.past.PastValidatorForCalendar;
import org.hibernate.validator.internal.constraintvalidators.bv.past.PastValidatorForChronoZonedDateTime;
import org.hibernate.validator.internal.constraintvalidators.bv.past.PastValidatorForDate;
import org.hibernate.validator.internal.constraintvalidators.bv.past.PastValidatorForInstant;
import org.hibernate.validator.internal.constraintvalidators.bv.past.PastValidatorForOffsetDateTime;
import org.hibernate.validator.internal.constraintvalidators.bv.past.PastValidatorForReadableInstant;
import org.hibernate.validator.internal.constraintvalidators.bv.past.PastValidatorForReadablePartial;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArray;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfBoolean;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfByte;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfChar;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfDouble;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfFloat;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfInt;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfLong;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForArraysOfShort;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForCollection;
import org.hibernate.validator.internal.constraintvalidators.bv.size.SizeValidatorForMap;
import org.hibernate.validator.internal.constraintvalidators.hv.EANValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.LengthValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.LuhnCheckValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.Mod10CheckValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.Mod11CheckValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.ModCheckValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.NotBlankValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.ParameterScriptAssertValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.SafeHtmlValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.ScriptAssertValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.URLValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.br.CNPJValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.br.CPFValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.pl.NIPValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.pl.PESELValidator;
import org.hibernate.validator.internal.constraintvalidators.hv.pl.REGONValidator;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.Version;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetAnnotationParameter;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;

public class ConstraintHelper {
    public static final String GROUPS = "groups";
    public static final String PAYLOAD = "payload";
    public static final String MESSAGE = "message";
    public static final String VALIDATION_APPLIES_TO = "validationAppliesTo";
    private static final Log log = LoggerFactory.make();
    private static final String JODA_TIME_CLASS_NAME = "org.joda.time.ReadableInstant";
    private static final String JAVA_MONEY_CLASS_NAME = "javax.money.MonetaryAmount";
    private final Map<Class<? extends Annotation>, List<? extends Class<?>>> builtinConstraints;
    private final ValidatorClassMap validatorClasses = new ValidatorClassMap();

    public ConstraintHelper() {
        HashMap<Class<? extends Annotation>, List<? extends Class<?>>> tmpConstraints = CollectionHelper.newHashMap();
        ConstraintHelper.putConstraint(tmpConstraints, AssertFalse.class, AssertFalseValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, AssertTrue.class, AssertTrueValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, CNPJ.class, CNPJValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, CPF.class, CPFValidator.class);
        if (ConstraintHelper.isJavaMoneyInClasspath()) {
            ConstraintHelper.putConstraint(tmpConstraints, Currency.class, CurrencyValidatorForMonetaryAmount.class);
            ConstraintHelper.putConstraints(tmpConstraints, DecimalMax.class, DecimalMaxValidatorForNumber.class, DecimalMaxValidatorForCharSequence.class, DecimalMaxValidatorForMonetaryAmount.class);
            ConstraintHelper.putConstraints(tmpConstraints, DecimalMin.class, DecimalMinValidatorForNumber.class, DecimalMinValidatorForCharSequence.class, DecimalMinValidatorForMonetaryAmount.class);
        } else {
            ConstraintHelper.putConstraints(tmpConstraints, DecimalMax.class, DecimalMaxValidatorForNumber.class, DecimalMaxValidatorForCharSequence.class);
            ConstraintHelper.putConstraints(tmpConstraints, DecimalMin.class, DecimalMinValidatorForNumber.class, DecimalMinValidatorForCharSequence.class);
        }
        ConstraintHelper.putConstraints(tmpConstraints, Digits.class, DigitsValidatorForCharSequence.class, DigitsValidatorForNumber.class);
        ArrayList futureValidators = CollectionHelper.newArrayList(11);
        futureValidators.add(FutureValidatorForCalendar.class);
        futureValidators.add(FutureValidatorForDate.class);
        if (ConstraintHelper.isJodaTimeInClasspath()) {
            futureValidators.add(FutureValidatorForReadableInstant.class);
            futureValidators.add(FutureValidatorForReadablePartial.class);
        }
        if (Version.getJavaRelease() >= 8) {
            futureValidators.add(FutureValidatorForChronoZonedDateTime.class);
            futureValidators.add(FutureValidatorForInstant.class);
            futureValidators.add(FutureValidatorForOffsetDateTime.class);
        }
        ConstraintHelper.putConstraints(tmpConstraints, Future.class, futureValidators);
        if (ConstraintHelper.isJavaMoneyInClasspath()) {
            ConstraintHelper.putConstraints(tmpConstraints, Max.class, MaxValidatorForNumber.class, MaxValidatorForCharSequence.class, MaxValidatorForMonetaryAmount.class);
            ConstraintHelper.putConstraints(tmpConstraints, Min.class, MinValidatorForNumber.class, MinValidatorForCharSequence.class, MinValidatorForMonetaryAmount.class);
        } else {
            ConstraintHelper.putConstraints(tmpConstraints, Max.class, MaxValidatorForNumber.class, MaxValidatorForCharSequence.class);
            ConstraintHelper.putConstraints(tmpConstraints, Min.class, MinValidatorForNumber.class, MinValidatorForCharSequence.class);
        }
        ConstraintHelper.putConstraint(tmpConstraints, NotNull.class, NotNullValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, Null.class, NullValidator.class);
        ArrayList pastValidators = CollectionHelper.newArrayList(11);
        pastValidators.add(PastValidatorForCalendar.class);
        pastValidators.add(PastValidatorForDate.class);
        if (ConstraintHelper.isJodaTimeInClasspath()) {
            pastValidators.add(PastValidatorForReadableInstant.class);
            pastValidators.add(PastValidatorForReadablePartial.class);
        }
        if (Version.getJavaRelease() >= 8) {
            pastValidators.add(PastValidatorForChronoZonedDateTime.class);
            pastValidators.add(PastValidatorForInstant.class);
            pastValidators.add(PastValidatorForOffsetDateTime.class);
        }
        ConstraintHelper.putConstraints(tmpConstraints, Past.class, pastValidators);
        ConstraintHelper.putConstraint(tmpConstraints, Pattern.class, PatternValidator.class);
        ArrayList sizeValidators = CollectionHelper.newArrayList(11);
        sizeValidators.add(SizeValidatorForCharSequence.class);
        sizeValidators.add(SizeValidatorForCollection.class);
        sizeValidators.add(SizeValidatorForArray.class);
        sizeValidators.add(SizeValidatorForMap.class);
        sizeValidators.add(SizeValidatorForArraysOfBoolean.class);
        sizeValidators.add(SizeValidatorForArraysOfByte.class);
        sizeValidators.add(SizeValidatorForArraysOfChar.class);
        sizeValidators.add(SizeValidatorForArraysOfDouble.class);
        sizeValidators.add(SizeValidatorForArraysOfFloat.class);
        sizeValidators.add(SizeValidatorForArraysOfInt.class);
        sizeValidators.add(SizeValidatorForArraysOfLong.class);
        sizeValidators.add(SizeValidatorForArraysOfShort.class);
        ConstraintHelper.putConstraints(tmpConstraints, Size.class, sizeValidators);
        ConstraintHelper.putConstraint(tmpConstraints, EAN.class, EANValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, Email.class, EmailValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, Length.class, LengthValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, ModCheck.class, ModCheckValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, LuhnCheck.class, LuhnCheckValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, Mod10Check.class, Mod10CheckValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, Mod11Check.class, Mod11CheckValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, REGON.class, REGONValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, NIP.class, NIPValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, PESEL.class, PESELValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, NotBlank.class, NotBlankValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, ParameterScriptAssert.class, ParameterScriptAssertValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, SafeHtml.class, SafeHtmlValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, ScriptAssert.class, ScriptAssertValidator.class);
        ConstraintHelper.putConstraint(tmpConstraints, URL.class, URLValidator.class);
        this.builtinConstraints = Collections.unmodifiableMap(tmpConstraints);
    }

    private static <A extends Annotation> void putConstraint(Map<Class<? extends Annotation>, List<? extends Class<?>>> validators, Class<A> constraintType, Class<? extends ConstraintValidator<A, ?>> validatorType) {
        validators.put(constraintType, Collections.singletonList(validatorType));
    }

    private static <A extends Annotation> void putConstraints(Map<Class<? extends Annotation>, List<? extends Class<?>>> validators, Class<A> constraintType, Class<? extends ConstraintValidator<A, ?>> validatorType1, Class<? extends ConstraintValidator<A, ?>> validatorType2) {
        validators.put(constraintType, Collections.unmodifiableList(Arrays.asList(validatorType1, validatorType2)));
    }

    private static <A extends Annotation> void putConstraints(Map<Class<? extends Annotation>, List<? extends Class<?>>> validators, Class<A> constraintType, Class<? extends ConstraintValidator<A, ?>> validatorType1, Class<? extends ConstraintValidator<A, ?>> validatorType2, Class<? extends ConstraintValidator<A, ?>> validatorType3) {
        validators.put(constraintType, Collections.unmodifiableList(Arrays.asList(validatorType1, validatorType2, validatorType3)));
    }

    private static <A extends Annotation> void putConstraints(Map<Class<? extends Annotation>, List<? extends Class<?>>> validators, Class<A> constraintType, List<Class<? extends ConstraintValidator<A, ?>>> validatorTypes) {
        validators.put(constraintType, Collections.unmodifiableList(validatorTypes));
    }

    private boolean isBuiltinConstraint(Class<? extends Annotation> annotationType) {
        return this.builtinConstraints.containsKey(annotationType);
    }

    public <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> getAllValidatorClasses(Class<A> annotationType) {
        List cachedValidatorClasses;
        Contracts.assertNotNull(annotationType, Messages.MESSAGES.classCannotBeNull());
        List classes = this.validatorClasses.get(annotationType);
        if (classes == null && (cachedValidatorClasses = this.validatorClasses.putIfAbsent(annotationType, classes = this.getDefaultValidatorClasses(annotationType))) != null) {
            classes = cachedValidatorClasses;
        }
        return Collections.unmodifiableList(classes);
    }

    public <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> findValidatorClasses(Class<A> annotationType, ValidationTarget validationTarget) {
        List<Class<ConstraintValidator<A, ?>>> validatorClasses = this.getAllValidatorClasses(annotationType);
        ArrayList<Class<ConstraintValidator<A, ?>>> matchingValidatorClasses = CollectionHelper.newArrayList();
        for (Class<ConstraintValidator<A, ?>> validatorClass : validatorClasses) {
            if (!this.supportsValidationTarget(validatorClass, validationTarget)) continue;
            matchingValidatorClasses.add(validatorClass);
        }
        return matchingValidatorClasses;
    }

    private boolean supportsValidationTarget(Class<? extends ConstraintValidator<?, ?>> validatorClass, ValidationTarget target) {
        SupportedValidationTarget supportedTargetAnnotation = validatorClass.getAnnotation(SupportedValidationTarget.class);
        if (supportedTargetAnnotation == null) {
            return target == ValidationTarget.ANNOTATED_ELEMENT;
        }
        return Arrays.asList(supportedTargetAnnotation.value()).contains((Object)target);
    }

    public <A extends Annotation> void putValidatorClasses(Class<A> annotationType, List<Class<? extends ConstraintValidator<A, ?>>> definitionClasses, boolean keepExistingClasses) {
        List<Class<ConstraintValidator<A, ?>>> existingClasses;
        if (keepExistingClasses && (existingClasses = this.getAllValidatorClasses(annotationType)) != null) {
            definitionClasses.addAll(0, existingClasses);
        }
        this.validatorClasses.put(annotationType, definitionClasses);
    }

    public boolean isMultiValueConstraint(Class<? extends Annotation> annotationType) {
        Class<?> returnType;
        boolean isMultiValueConstraint = false;
        Method method = ConstraintHelper.run(GetMethod.action(annotationType, "value"));
        if (method != null && (returnType = method.getReturnType()).isArray() && returnType.getComponentType().isAnnotation()) {
            Class<?> componentType = returnType.getComponentType();
            isMultiValueConstraint = this.isConstraintAnnotation(componentType) || this.isBuiltinConstraint(componentType);
        }
        return isMultiValueConstraint;
    }

    public <A extends Annotation> List<Annotation> getConstraintsFromMultiValueConstraint(A multiValueConstraint) {
        Annotation[] annotations = ConstraintHelper.run(GetAnnotationParameter.action(multiValueConstraint, "value", Annotation[].class));
        return Arrays.asList(annotations);
    }

    public boolean isConstraintAnnotation(Class<? extends Annotation> annotationType) {
        if (annotationType.getAnnotation(Constraint.class) == null) {
            return false;
        }
        this.assertMessageParameterExists(annotationType);
        this.assertGroupsParameterExists(annotationType);
        this.assertPayloadParameterExists(annotationType);
        this.assertValidationAppliesToParameterSetUpCorrectly(annotationType);
        this.assertNoParameterStartsWithValid(annotationType);
        return true;
    }

    private void assertNoParameterStartsWithValid(Class<? extends Annotation> annotationType) {
        Method[] methods;
        for (Method m3 : methods = ConstraintHelper.run(GetDeclaredMethods.action(annotationType))) {
            if (!m3.getName().startsWith("valid") || m3.getName().equals(VALIDATION_APPLIES_TO)) continue;
            throw log.getConstraintParametersCannotStartWithValidException();
        }
    }

    private void assertPayloadParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ConstraintHelper.run(GetMethod.action(annotationType, PAYLOAD));
            if (method == null) {
                throw log.getConstraintWithoutMandatoryParameterException(PAYLOAD, annotationType.getName());
            }
            Class[] defaultPayload = (Class[])method.getDefaultValue();
            if (defaultPayload.length != 0) {
                throw log.getWrongDefaultValueForPayloadParameterException(annotationType.getName());
            }
        }
        catch (ClassCastException e) {
            throw log.getWrongTypeForPayloadParameterException(annotationType.getName(), e);
        }
    }

    private void assertGroupsParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ConstraintHelper.run(GetMethod.action(annotationType, GROUPS));
            if (method == null) {
                throw log.getConstraintWithoutMandatoryParameterException(GROUPS, annotationType.getName());
            }
            Class[] defaultGroups = (Class[])method.getDefaultValue();
            if (defaultGroups.length != 0) {
                throw log.getWrongDefaultValueForGroupsParameterException(annotationType.getName());
            }
        }
        catch (ClassCastException e) {
            throw log.getWrongTypeForGroupsParameterException(annotationType.getName(), e);
        }
    }

    private void assertMessageParameterExists(Class<? extends Annotation> annotationType) {
        Method method = ConstraintHelper.run(GetMethod.action(annotationType, MESSAGE));
        if (method == null) {
            throw log.getConstraintWithoutMandatoryParameterException(MESSAGE, annotationType.getName());
        }
        if (method.getReturnType() != String.class) {
            throw log.getWrongTypeForMessageParameterException(annotationType.getName());
        }
    }

    private void assertValidationAppliesToParameterSetUpCorrectly(Class<? extends Annotation> annotationType) {
        boolean hasGenericValidators = !this.findValidatorClasses(annotationType, ValidationTarget.ANNOTATED_ELEMENT).isEmpty();
        boolean hasCrossParameterValidator = !this.findValidatorClasses(annotationType, ValidationTarget.PARAMETERS).isEmpty();
        Method method = ConstraintHelper.run(GetMethod.action(annotationType, VALIDATION_APPLIES_TO));
        if (hasGenericValidators && hasCrossParameterValidator) {
            if (method == null) {
                throw log.getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException(annotationType);
            }
            if (method.getReturnType() != ConstraintTarget.class) {
                throw log.getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException(annotationType);
            }
            ConstraintTarget defaultValue = (ConstraintTarget)((Object)method.getDefaultValue());
            if (defaultValue != ConstraintTarget.IMPLICIT) {
                throw log.getValidationAppliesToParameterMustHaveDefaultValueImplicitException(annotationType);
            }
        } else if (method != null) {
            throw log.getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException(annotationType);
        }
    }

    public boolean isConstraintComposition(Class<? extends Annotation> annotationType) {
        return annotationType == ConstraintComposition.class;
    }

    private static boolean isJodaTimeInClasspath() {
        return ConstraintHelper.isClassPresent(JODA_TIME_CLASS_NAME);
    }

    private static boolean isJavaMoneyInClasspath() {
        return ConstraintHelper.isClassPresent(JAVA_MONEY_CLASS_NAME);
    }

    private <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> getDefaultValidatorClasses(Class<A> annotationType) {
        List<Class<? extends ConstraintValidator<A, ?>>> builtInValidators = this.builtinConstraints.get(annotationType);
        if (builtInValidators != null) {
            return builtInValidators;
        }
        Class<? extends ConstraintValidator<?, ?>>[] validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
        return Arrays.asList(validatedBy);
    }

    private static boolean isClassPresent(String className) {
        try {
            ConstraintHelper.run(LoadClass.action(className, ConstraintHelper.class.getClassLoader()));
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private static class ValidatorClassMap {
        private final ConcurrentMap<Class<? extends Annotation>, List<? extends Class<?>>> constraintValidatorClasses = CollectionHelper.newConcurrentHashMap();

        private ValidatorClassMap() {
        }

        private <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> get(Class<A> annotationType) {
            return (List)this.constraintValidatorClasses.get(annotationType);
        }

        private <A extends Annotation> void put(Class<A> annotationType, List<Class<? extends ConstraintValidator<A, ?>>> validatorClasses) {
            this.constraintValidatorClasses.put(annotationType, validatorClasses);
        }

        private <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> putIfAbsent(Class<A> annotationType, List<Class<? extends ConstraintValidator<A, ?>>> classes) {
            return this.constraintValidatorClasses.putIfAbsent(annotationType, classes);
        }
    }
}

