/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.valuehandling;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public abstract class TypeResolverBasedValueUnwrapper<T>
extends ValidatedValueUnwrapper<T> {
    private final Class<?> clazz;
    private final TypeResolver typeResolver;

    TypeResolverBasedValueUnwrapper(TypeResolutionHelper typeResolutionHelper) {
        this.typeResolver = typeResolutionHelper.getTypeResolver();
        this.clazz = TypeResolverBasedValueUnwrapper.resolveSingleTypeParameter(this.typeResolver, this.getClass(), ValidatedValueUnwrapper.class);
    }

    @Override
    public Type getValidatedValueType(Type valueType) {
        return TypeResolverBasedValueUnwrapper.resolveSingleTypeParameter(this.typeResolver, valueType, this.clazz);
    }

    private static Class<?> resolveSingleTypeParameter(TypeResolver typeResolver, Type subType, Class<?> target) {
        ResolvedType resolvedType = typeResolver.resolve(subType, new Type[0]);
        return resolvedType.typeParametersFor(target).get(0).getErasedType();
    }
}

