/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv.past;

import java.time.Instant;
import java.time.OffsetDateTime;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Past;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.hibernate.validator.internal.util.IgnoreJava6Requirement;
import org.hibernate.validator.spi.time.TimeProvider;

@IgnoreJava6Requirement
public class PastValidatorForOffsetDateTime
implements ConstraintValidator<Past, OffsetDateTime> {
    @Override
    public void initialize(Past constraintAnnotation) {
    }

    @Override
    public boolean isValid(OffsetDateTime value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        TimeProvider timeProvider = context.unwrap(HibernateConstraintValidatorContext.class).getTimeProvider();
        OffsetDateTime reference = OffsetDateTime.ofInstant(Instant.ofEpochMilli(timeProvider.getCurrentTime()), value.getOffset());
        return value.compareTo(reference) < 0;
    }
}

