/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.marshaller.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.kencochrane.raven.event.interfaces.MessageInterface;
import net.kencochrane.raven.marshaller.json.InterfaceBinding;

public class MessageInterfaceBinding
implements InterfaceBinding<MessageInterface> {
    public static final int MAX_MESSAGE_LENGTH = 1000;
    private static final String MESSAGE_PARAMETER = "message";
    private static final String PARAMS_PARAMETER = "params";

    private String formatMessage(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() > 1000) {
            return message.substring(0, 1000);
        }
        return message;
    }

    @Override
    public void writeInterface(JsonGenerator generator, MessageInterface messageInterface) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(MESSAGE_PARAMETER, this.formatMessage(messageInterface.getMessage()));
        generator.writeArrayFieldStart(PARAMS_PARAMETER);
        for (String parameter : messageInterface.getParameters()) {
            generator.writeString(parameter);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

