/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.marshaller.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.SentryException;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;
import net.kencochrane.raven.marshaller.json.InterfaceBinding;

public class ExceptionInterfaceBinding
implements InterfaceBinding<ExceptionInterface> {
    private static final String TYPE_PARAMETER = "type";
    private static final String VALUE_PARAMETER = "value";
    private static final String MODULE_PARAMETER = "module";
    private static final String STACKTRACE_PARAMETER = "stacktrace";
    private final InterfaceBinding<StackTraceInterface> stackTraceInterfaceBinding;

    public ExceptionInterfaceBinding(InterfaceBinding<StackTraceInterface> stackTraceInterfaceBinding) {
        this.stackTraceInterfaceBinding = stackTraceInterfaceBinding;
    }

    @Override
    public void writeInterface(JsonGenerator generator, ExceptionInterface exceptionInterface) throws IOException {
        Deque<SentryException> exceptions = exceptionInterface.getExceptions();
        generator.writeStartArray();
        Iterator<SentryException> iterator = exceptions.descendingIterator();
        while (iterator.hasNext()) {
            this.writeException(generator, iterator.next());
        }
        generator.writeEndArray();
    }

    private void writeException(JsonGenerator generator, SentryException sentryException) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(TYPE_PARAMETER, sentryException.getExceptionClassName());
        generator.writeStringField(VALUE_PARAMETER, sentryException.getExceptionMessage());
        generator.writeStringField(MODULE_PARAMETER, sentryException.getExceptionPackageName());
        generator.writeFieldName(STACKTRACE_PARAMETER);
        this.stackTraceInterfaceBinding.writeInterface(generator, sentryException.getStackTraceInterface());
        generator.writeEndObject();
    }
}

