/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.event.helper;

import javax.servlet.http.HttpServletRequest;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.helper.EventBuilderHelper;
import net.kencochrane.raven.event.interfaces.HttpInterface;
import net.kencochrane.raven.event.interfaces.UserInterface;
import net.kencochrane.raven.servlet.RavenServletRequestListener;

public class HttpEventBuilderHelper
implements EventBuilderHelper {
    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        HttpServletRequest servletRequest = RavenServletRequestListener.getServletRequest();
        if (servletRequest == null) {
            return;
        }
        this.addHttpInterface(eventBuilder, servletRequest);
        this.addUserInterface(eventBuilder, servletRequest);
    }

    private void addHttpInterface(EventBuilder eventBuilder, HttpServletRequest servletRequest) {
        eventBuilder.withSentryInterface(new HttpInterface(servletRequest), false);
    }

    private void addUserInterface(EventBuilder eventBuilder, HttpServletRequest servletRequest) {
        String username = null;
        if (servletRequest.getUserPrincipal() != null) {
            username = servletRequest.getUserPrincipal().getName();
        }
        UserInterface userInterface = new UserInterface(null, username, servletRequest.getRemoteAddr(), null);
        eventBuilder.withSentryInterface(userInterface, false);
    }
}

