/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.ContainerSpec;
import com.spotify.docker.client.messages.swarm.Driver;
import com.spotify.docker.client.messages.swarm.NetworkAttachmentConfig;
import com.spotify.docker.client.messages.swarm.Placement;
import com.spotify.docker.client.messages.swarm.ResourceRequirements;
import com.spotify.docker.client.messages.swarm.RestartPolicy;
import com.spotify.docker.client.messages.swarm.TaskSpec;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_TaskSpec
extends TaskSpec {
    private final ContainerSpec containerSpec;
    private final ResourceRequirements resources;
    private final RestartPolicy restartPolicy;
    private final Placement placement;
    private final ImmutableList<NetworkAttachmentConfig> networks;
    private final Driver logDriver;

    private AutoValue_TaskSpec(@Nullable ContainerSpec containerSpec, @Nullable ResourceRequirements resources, @Nullable RestartPolicy restartPolicy, @Nullable Placement placement, @Nullable ImmutableList<NetworkAttachmentConfig> networks, @Nullable Driver logDriver) {
        this.containerSpec = containerSpec;
        this.resources = resources;
        this.restartPolicy = restartPolicy;
        this.placement = placement;
        this.networks = networks;
        this.logDriver = logDriver;
    }

    @Override
    @Nullable
    @JsonProperty(value="ContainerSpec")
    public ContainerSpec containerSpec() {
        return this.containerSpec;
    }

    @Override
    @Nullable
    @JsonProperty(value="Resources")
    public ResourceRequirements resources() {
        return this.resources;
    }

    @Override
    @Nullable
    @JsonProperty(value="RestartPolicy")
    public RestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    @Override
    @Nullable
    @JsonProperty(value="Placement")
    public Placement placement() {
        return this.placement;
    }

    @Override
    @Nullable
    @JsonProperty(value="Networks")
    public ImmutableList<NetworkAttachmentConfig> networks() {
        return this.networks;
    }

    @Override
    @Nullable
    @JsonProperty(value="LogDriver")
    public Driver logDriver() {
        return this.logDriver;
    }

    public String toString() {
        return "TaskSpec{containerSpec=" + this.containerSpec + ", " + "resources=" + this.resources + ", " + "restartPolicy=" + this.restartPolicy + ", " + "placement=" + this.placement + ", " + "networks=" + this.networks + ", " + "logDriver=" + this.logDriver + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TaskSpec) {
            TaskSpec that = (TaskSpec)o;
            return (this.containerSpec == null ? that.containerSpec() == null : this.containerSpec.equals(that.containerSpec())) && (this.resources == null ? that.resources() == null : this.resources.equals(that.resources())) && (this.restartPolicy == null ? that.restartPolicy() == null : this.restartPolicy.equals(that.restartPolicy())) && (this.placement == null ? that.placement() == null : this.placement.equals(that.placement())) && (this.networks == null ? that.networks() == null : this.networks.equals(that.networks())) && (this.logDriver == null ? that.logDriver() == null : this.logDriver.equals(that.logDriver()));
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.containerSpec == null ? 0 : this.containerSpec.hashCode();
        h2 *= 1000003;
        h2 ^= this.resources == null ? 0 : this.resources.hashCode();
        h2 *= 1000003;
        h2 ^= this.restartPolicy == null ? 0 : this.restartPolicy.hashCode();
        h2 *= 1000003;
        h2 ^= this.placement == null ? 0 : this.placement.hashCode();
        h2 *= 1000003;
        h2 ^= this.networks == null ? 0 : this.networks.hashCode();
        h2 *= 1000003;
        return h2 ^= this.logDriver == null ? 0 : this.logDriver.hashCode();
    }

    static final class Builder
    extends TaskSpec.Builder {
        private ContainerSpec containerSpec;
        private ResourceRequirements resources;
        private RestartPolicy restartPolicy;
        private Placement placement;
        private ImmutableList<NetworkAttachmentConfig> networks;
        private Driver logDriver;

        Builder() {
        }

        Builder(TaskSpec source) {
            this.containerSpec = source.containerSpec();
            this.resources = source.resources();
            this.restartPolicy = source.restartPolicy();
            this.placement = source.placement();
            this.networks = source.networks();
            this.logDriver = source.logDriver();
        }

        @Override
        public TaskSpec.Builder containerSpec(@Nullable ContainerSpec containerSpec) {
            this.containerSpec = containerSpec;
            return this;
        }

        @Override
        public TaskSpec.Builder resources(@Nullable ResourceRequirements resources) {
            this.resources = resources;
            return this;
        }

        @Override
        public TaskSpec.Builder restartPolicy(@Nullable RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        @Override
        public TaskSpec.Builder placement(@Nullable Placement placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public TaskSpec.Builder networks(NetworkAttachmentConfig ... networks) {
            this.networks = networks == null ? null : ImmutableList.copyOf(networks);
            return this;
        }

        @Override
        public TaskSpec.Builder networks(@Nullable List<NetworkAttachmentConfig> networks) {
            this.networks = networks == null ? null : ImmutableList.copyOf(networks);
            return this;
        }

        @Override
        public TaskSpec.Builder logDriver(@Nullable Driver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        @Override
        public TaskSpec build() {
            return new AutoValue_TaskSpec(this.containerSpec, this.resources, this.restartPolicy, this.placement, this.networks, this.logDriver);
        }
    }
}

