/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslUtils {
    private SSLContext looseTrustManagerSSLContext = this.looseTrustManagerSSLContext();

    private SSLContext looseTrustManagerSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new LooseTrustManager()}, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (KeyManagementException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static SslUtils getInstance() {
        return SingletonHolder.instance;
    }

    public SSLContext getSSLContext(AsyncHttpClientConfig config) throws GeneralSecurityException {
        SSLContext sslContext = config.getSSLContext();
        if (sslContext == null) {
            SSLContext sSLContext = sslContext = config.isAcceptAnyCertificate() ? this.looseTrustManagerSSLContext : SSLContext.getDefault();
            if (config.getSslSessionCacheSize() != null) {
                sslContext.getClientSessionContext().setSessionCacheSize(config.getSslSessionCacheSize());
            }
            if (config.getSslSessionTimeout() != null) {
                sslContext.getClientSessionContext().setSessionTimeout(config.getSslSessionTimeout());
            }
        }
        return sslContext;
    }

    private static class SingletonHolder {
        public static final SslUtils instance = new SslUtils();

        private SingletonHolder() {
        }
    }

    static class LooseTrustManager
    implements X509TrustManager {
        LooseTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

