/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.response;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseHeaders;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpHeaders;

public class NettyResponseHeaders
extends HttpResponseHeaders {
    private final HttpHeaders responseHeaders;
    private final HttpHeaders trailingHeaders;
    private final FluentCaseInsensitiveStringsMap headers;

    public NettyResponseHeaders(HttpHeaders responseHeaders) {
        this(responseHeaders, null);
    }

    public NettyResponseHeaders(HttpHeaders responseHeaders, HttpHeaders traillingHeaders) {
        super(traillingHeaders != null);
        this.responseHeaders = responseHeaders;
        this.trailingHeaders = traillingHeaders;
        this.headers = this.computerHeaders();
    }

    private FluentCaseInsensitiveStringsMap computerHeaders() {
        FluentCaseInsensitiveStringsMap h2 = new FluentCaseInsensitiveStringsMap();
        for (Map.Entry header : this.responseHeaders) {
            h2.add((String)header.getKey(), (String)header.getValue());
        }
        if (this.trailingHeaders != null) {
            for (Map.Entry header : this.trailingHeaders) {
                h2.add((String)header.getKey(), (String)header.getValue());
            }
        }
        return h2;
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers;
    }
}

