/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.providers.grizzly.AhcEventFilter;
import com.ning.http.client.providers.grizzly.AhcSSLEngineConfigurator;
import com.ning.http.client.providers.grizzly.AsyncHttpClientFilter;
import com.ning.http.client.providers.grizzly.ConnectionManager;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import com.ning.http.client.providers.grizzly.SwitchingSSLFilter;
import com.ning.http.client.providers.grizzly.TransportCustomizer;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyAsyncHttpProvider.class);
    private final TCPNIOTransport clientTransport;
    private final AsyncHttpClientConfig clientConfig;
    private final GrizzlyAsyncHttpProviderConfig providerConfig;
    private final ConnectionManager connectionManager;
    DelayedExecutor.Resolver<Connection> resolver;
    private DelayedExecutor timeoutExecutor;

    public GrizzlyAsyncHttpProvider(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.providerConfig = clientConfig.getAsyncHttpProviderConfig() instanceof GrizzlyAsyncHttpProviderConfig ? (GrizzlyAsyncHttpProviderConfig)clientConfig.getAsyncHttpProviderConfig() : new GrizzlyAsyncHttpProviderConfig();
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        this.clientTransport = builder.build();
        this.initializeTransport(clientConfig);
        this.connectionManager = new ConnectionManager(this, this.clientTransport, this.providerConfig);
        try {
            this.clientTransport.start();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public <T> ListenableFuture<T> execute(final Request request, AsyncHandler<T> asyncHandler) {
        if (this.clientTransport.isStopped()) {
            IOException e = new IOException("AsyncHttpClient has been closed.");
            asyncHandler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
        final GrizzlyResponseFuture future = new GrizzlyResponseFuture(asyncHandler);
        CompletionHandler<Connection> connectHandler = new CompletionHandler<Connection>(){

            public void cancelled() {
                future.cancel(true);
            }

            public void failed(Throwable throwable) {
                future.abort(throwable);
            }

            public void completed(Connection c) {
                block7: {
                    try {
                        HttpTransactionContext tx = HttpTransactionContext.startTransaction(c, GrizzlyAsyncHttpProvider.this, request, future);
                        if (future.setHttpTransactionCtx(tx)) {
                            GrizzlyAsyncHttpProvider.this.execute(tx);
                        } else {
                            tx.closeConnection();
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            this.failed(e);
                        } else if (e instanceof IOException) {
                            this.failed(e);
                        }
                        if (!LOGGER.isWarnEnabled()) break block7;
                        LOGGER.warn(e.toString(), e);
                    }
                }
            }

            public void updated(Connection c) {
            }
        };
        try {
            this.connectionManager.openAsync(request, connectHandler);
        }
        catch (IOException ioe) {
            this.abort(future, ioe);
        }
        catch (RuntimeException re) {
            this.abort(future, re);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(e.toString(), e);
            }
            this.abort(future, e);
        }
        return future;
    }

    private void abort(GrizzlyResponseFuture<?> future, Throwable t) {
        if (!future.isDone()) {
            LOGGER.debug("Aborting Future {}\n", (Object)future);
            LOGGER.debug(t.getMessage(), t);
            future.abort(t);
        }
    }

    @Override
    public void close() {
        try {
            this.connectionManager.destroy();
            this.clientTransport.shutdownNow();
            ExecutorService service = this.clientConfig.executorService();
            if (service != null) {
                service.shutdown();
            }
            if (this.timeoutExecutor != null) {
                this.timeoutExecutor.stop();
                this.timeoutExecutor.getThreadPool().shutdownNow();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void execute(HttpTransactionContext transactionCtx) throws IOException {
        block4: {
            try {
                transactionCtx.getConnection().write((Object)transactionCtx, this.createWriteCompletionHandler(transactionCtx.future));
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn(e.toString(), e);
            }
        }
    }

    protected void initializeTransport(final AsyncHttpClientConfig clientConfig) {
        FilterChainBuilder fcb = FilterChainBuilder.stateless();
        fcb.add((Filter)new TransportFilter());
        final int timeout = clientConfig.getRequestTimeout();
        if (timeout > 0) {
            int delay = 500;
            if (timeout < delay) {
                delay = timeout - 10;
            }
            this.timeoutExecutor = IdleTimeoutFilter.createDefaultIdleDelayedExecutor((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
            this.timeoutExecutor.start();
            IdleTimeoutFilter.TimeoutResolver timeoutResolver = new IdleTimeoutFilter.TimeoutResolver(){

                public long getTimeout(FilterChainContext ctx) {
                    Connection connection = ctx.getConnection();
                    if (GrizzlyAsyncHttpProvider.this.connectionManager.isReadyInPool(connection)) {
                        return IdleTimeoutFilter.FOREVER;
                    }
                    HttpTransactionContext context = HttpTransactionContext.currentTransaction((AttributeStorage)connection);
                    if (context != null) {
                        if (context.isWSRequest) {
                            return clientConfig.getWebSocketTimeout();
                        }
                        long timeout2 = context.getAhcRequest().getRequestTimeout();
                        if (timeout2 > 0L) {
                            return timeout2;
                        }
                    }
                    return timeout;
                }
            };
            IdleTimeoutFilter timeoutFilter = new IdleTimeoutFilter(this.timeoutExecutor, timeoutResolver, new IdleTimeoutFilter.TimeoutHandler(){

                public void onTimeout(Connection connection) {
                    GrizzlyAsyncHttpProvider.this.timeout(connection);
                }
            });
            fcb.add((Filter)timeoutFilter);
            this.resolver = timeoutFilter.getResolver();
        }
        boolean defaultSecState = clientConfig.getSSLContext() != null;
        AhcSSLEngineConfigurator configurator = new AhcSSLEngineConfigurator(this.providerConfig.getSslEngineFactory() != null ? this.providerConfig.getSslEngineFactory() : new SSLEngineFactory.DefaultSSLEngineFactory(clientConfig));
        SwitchingSSLFilter sslFilter = new SwitchingSSLFilter(configurator, defaultSecState);
        fcb.add((Filter)sslFilter);
        AhcEventFilter eventFilter = new AhcEventFilter(this, (Integer)this.providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.MAX_HTTP_PACKET_HEADER_SIZE));
        AsyncHttpClientFilter clientFilter = new AsyncHttpClientFilter(this);
        ContentEncoding[] encodings = eventFilter.getContentEncodings();
        if (encodings.length > 0) {
            for (ContentEncoding encoding : encodings) {
                eventFilter.removeContentEncoding(encoding);
            }
        }
        if (((Boolean)this.providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.DECOMPRESS_RESPONSE)).booleanValue()) {
            eventFilter.addContentEncoding((ContentEncoding)new GZipContentEncoding(512, 512, (EncodingFilter)new ClientEncodingFilter()));
        }
        fcb.add((Filter)eventFilter);
        fcb.add((Filter)clientFilter);
        this.clientTransport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(-2);
        this.clientTransport.setNIOChannelDistributor((NIOChannelDistributor)new RoundRobinConnectionDistributor((NIOTransport)this.clientTransport, false, false));
        int kernelThreadsCount = clientConfig.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
        this.clientTransport.setSelectorRunnersCount(kernelThreadsCount);
        this.clientTransport.setKernelThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(kernelThreadsCount).setMaxPoolSize(kernelThreadsCount).setPoolName("grizzly-ahc-kernel"));
        TransportCustomizer customizer = (TransportCustomizer)this.providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER);
        if (customizer != null) {
            customizer.customize(this.clientTransport, fcb);
        } else {
            this.doDefaultTransportConfig();
        }
        fcb.add((Filter)new WebSocketFilter());
        this.clientTransport.setProcessor((Processor)fcb.build());
    }

    void touchConnection(Connection c, Request request) {
        long timeOut;
        long l = timeOut = request.getRequestTimeout() > 0 ? (long)request.getRequestTimeout() : (long)this.clientConfig.getRequestTimeout();
        if (timeOut > 0L && this.resolver != null) {
            this.resolver.setTimeoutMillis((Object)c, System.currentTimeMillis() + timeOut);
        }
    }

    private static boolean configSendFileSupport() {
        return (!System.getProperty("os.name").equalsIgnoreCase("linux") || GrizzlyAsyncHttpProvider.linuxSendFileSupported()) && !System.getProperty("os.name").equalsIgnoreCase("HP-UX");
    }

    private static boolean linuxSendFileSupported() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6")) {
            int idx = version.indexOf(95);
            if (idx == -1) {
                return false;
            }
            int patchRev = Integer.parseInt(version.substring(idx + 1));
            return patchRev >= 18;
        }
        return version.startsWith("1.7") || version.startsWith("1.8");
    }

    private void doDefaultTransportConfig() {
        ExecutorService service = this.clientConfig.executorService();
        if (service != null) {
            this.clientTransport.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
            this.clientTransport.setWorkerThreadPool(service);
        } else {
            this.clientTransport.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
        }
    }

    private <T> CompletionHandler<WriteResult> createWriteCompletionHandler(final GrizzlyResponseFuture<T> future) {
        return new CompletionHandler<WriteResult>(){

            public void cancelled() {
                future.cancel(true);
            }

            public void failed(Throwable throwable) {
                future.abort(throwable);
            }

            public void completed(WriteResult result) {
            }

            public void updated(WriteResult result) {
            }
        };
    }

    void timeout(Connection c) {
        HttpTransactionContext tx = HttpTransactionContext.currentTransaction((AttributeStorage)c);
        TimeoutException te = new TimeoutException("Timeout exceeded");
        if (tx != null) {
            tx.abort(te);
        }
        c.closeWithReason(new IOException("Timeout exceeded", te));
    }

    public static void main(String[] args) {
        SecureRandom secureRandom = new SecureRandom();
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, secureRandom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).setSSLContext(sslContext).build();
        AsyncHttpClient client = new AsyncHttpClient(new GrizzlyAsyncHttpProvider(config), config);
        long start = System.currentTimeMillis();
        try {
            client.executeRequest(client.prepareGet("http://www.google.com").build()).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        LOGGER.debug("COMPLETE: " + (System.currentTimeMillis() - start) + "ms");
    }

    private static final class ClientEncodingFilter
    implements EncodingFilter {
        private ClientEncodingFilter() {
        }

        public boolean applyEncoding(HttpHeader httpPacket) {
            return false;
        }

        public boolean applyDecoding(HttpHeader httpPacket) {
            HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
            DataChunk bc = httpResponse.getHeaders().getValue(Header.ContentEncoding);
            return bc != null && bc.indexOf("gzip", 0) != -1;
        }
    }
}

