/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.UpgradeHandler;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.providers.grizzly.AhcHttpContext;
import com.ning.http.client.providers.grizzly.ConnectionManager;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import com.ning.http.client.providers.grizzly.PayloadGenFactory;
import com.ning.http.client.providers.grizzly.PayloadGenerator;
import com.ning.http.client.providers.grizzly.Utils;
import com.ning.http.client.providers.grizzly.events.ContinueEvent;
import com.ning.http.client.providers.grizzly.events.SSLSwitchingEvent;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncHttpClientFilter
extends BaseFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHttpClientFilter.class);
    private static final Attribute<Boolean> USED_CONNECTION = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(AsyncHttpClientFilter.class.getName() + ".used-connection");
    private static final HeaderValue KEEP_ALIVE_VALUE = HeaderValue.newHeaderValue((String)"keep-alive");
    private static final HeaderValue CLOSE_VALUE = HeaderValue.newHeaderValue((String)"close");
    private final AsyncHttpClientConfig config;

    AsyncHttpClientFilter(GrizzlyAsyncHttpProvider provider) {
        this.config = provider.getClientConfig();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (message instanceof HttpTransactionContext) {
            ctx.setMessage(null);
            if (!this.sendAsGrizzlyRequest((HttpTransactionContext)message, ctx)) {
                return ctx.getSuspendAction();
            }
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        Object type = event.type();
        if (type == ContinueEvent.class) {
            ContinueEvent continueEvent = (ContinueEvent)event;
            continueEvent.getContext().payloadGenerator.continueConfirmed(ctx);
        }
        return ctx.getStopAction();
    }

    private boolean sendAsGrizzlyRequest(HttpTransactionContext httpTxCtx, FilterChainContext ctx) throws IOException {
        HttpRequestPacket requestPacket;
        PayloadGenerator payloadGenerator;
        boolean isEstablishingConnectTunnel;
        Connection connection = ctx.getConnection();
        boolean isUsedConnection = Boolean.TRUE.equals(USED_CONNECTION.get((AttributeStorage)connection));
        if (!isUsedConnection) {
            USED_CONNECTION.set((AttributeStorage)connection, (Object)Boolean.TRUE);
        }
        Request ahcRequest = httpTxCtx.getAhcRequest();
        if (this.isUpgradeRequest(httpTxCtx.getAsyncHandler()) && this.isWSRequest(httpTxCtx.requestUri)) {
            httpTxCtx.isWSRequest = true;
            this.convertToUpgradeRequest(httpTxCtx);
        }
        Request req = httpTxCtx.getAhcRequest();
        Method method = Method.valueOf((String)ahcRequest.getMethod());
        Uri uri = req.getUri();
        boolean secure = "https".equals(uri.getScheme());
        ProxyServer proxy = httpTxCtx.getProxyServer();
        boolean useProxy = proxy != null;
        boolean bl = isEstablishingConnectTunnel = useProxy && (secure || httpTxCtx.isWSRequest) && !httpTxCtx.isTunnelEstablished(connection);
        if (isEstablishingConnectTunnel) {
            return this.establishConnectTunnel(proxy, httpTxCtx, uri, ctx);
        }
        HttpRequestPacket.Builder builder = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().protocol(Protocol.HTTP_1_1)).method(method);
        if (useProxy && (!secure && !httpTxCtx.isWSRequest || !this.config.isUseRelativeURIsWithConnectProxies())) {
            builder.uri(uri.toUrl());
        } else {
            builder.uri(AsyncHttpProviderUtils.getNonEmptyPath(uri)).query(uri.getQuery());
        }
        PayloadGenerator payloadGenerator2 = payloadGenerator = this.isPayloadAllowed(method) ? PayloadGenFactory.getPayloadGenerator(ahcRequest) : null;
        if (payloadGenerator != null) {
            long contentLength = ahcRequest.getContentLength();
            if (contentLength >= 0L) {
                ((HttpRequestPacket.Builder)builder.contentLength(contentLength)).chunked(false);
            } else {
                builder.chunked(true);
            }
        }
        if (httpTxCtx.isWSRequest) {
            try {
                URI wsURI = httpTxCtx.wsRequestURI.toJavaNetURI();
                secure = "wss".equalsIgnoreCase(wsURI.getScheme());
                httpTxCtx.protocolHandler = Version.RFC6455.createHandler(true);
                httpTxCtx.handshake = httpTxCtx.protocolHandler.createClientHandShake(wsURI);
                requestPacket = (HttpRequestPacket)httpTxCtx.handshake.composeHeaders().getHttpHeader();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid WS URI: " + httpTxCtx.wsRequestURI);
            }
        } else {
            requestPacket = builder.build();
        }
        requestPacket.setSecure(secure);
        this.setupKeepAlive(requestPacket, connection);
        this.copyHeaders(ahcRequest, requestPacket);
        this.addCookies(ahcRequest, requestPacket);
        this.addHostHeaderIfNeeded(ahcRequest, uri, requestPacket);
        this.addServiceHeaders(requestPacket);
        this.addAcceptHeaders(requestPacket);
        Realm realm = this.getRealm(ahcRequest);
        this.addAuthorizationHeader(ahcRequest, requestPacket, realm, uri, proxy, isUsedConnection);
        if (useProxy) {
            this.addProxyHeaders(ahcRequest, requestPacket, realm, proxy, isUsedConnection, false);
        }
        ctx.notifyDownstream((FilterChainEvent)new SSLSwitchingEvent(connection, secure, uri.getHost(), uri.getPort()));
        boolean isFullySent = this.sendRequest(httpTxCtx, ctx, requestPacket, this.wrapWithExpectHandlerIfNeeded(payloadGenerator, requestPacket));
        if (isFullySent) {
            httpTxCtx.onRequestFullySent();
        }
        return isFullySent;
    }

    private boolean establishConnectTunnel(ProxyServer proxy, HttpTransactionContext httpCtx, Uri uri, FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        HttpRequestPacket requestPacket = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().protocol(Protocol.HTTP_1_0)).method(Method.CONNECT).uri(AsyncHttpProviderUtils.getAuthority(uri)).build();
        this.setupKeepAlive(requestPacket, connection);
        httpCtx.establishingTunnel = true;
        Request request = httpCtx.getAhcRequest();
        this.addHostHeaderIfNeeded(request, uri, requestPacket);
        this.addServiceHeaders(requestPacket);
        Realm realm = this.getRealm(request);
        this.addAuthorizationHeader(request, requestPacket, realm, uri, proxy, false);
        this.addProxyHeaders(request, requestPacket, realm, proxy, false, true);
        ctx.notifyDownstream((FilterChainEvent)new SSLSwitchingEvent(connection, false));
        return this.sendRequest(httpCtx, ctx, requestPacket, null);
    }

    private boolean sendRequest(HttpTransactionContext httpTxCtx, FilterChainContext ctx, HttpRequestPacket requestPacket, PayloadGenerator payloadGenerator) throws IOException {
        Connection connection = httpTxCtx.getConnection();
        Request request = httpTxCtx.getAhcRequest();
        AsyncHandler h2 = httpTxCtx.getAsyncHandler();
        AhcHttpContext httpCtx = new AhcHttpContext((AttributeStorage)connection, (OutputSink)connection, (Closeable)connection, requestPacket, httpTxCtx);
        HttpTransactionContext.bind(httpCtx, httpTxCtx);
        requestPacket.getProcessingState().setHttpContext((HttpContext)httpCtx);
        httpCtx.attach(ctx);
        if (h2 instanceof TransferCompletionHandler) {
            FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap(request.getHeaders());
            ((TransferCompletionHandler)TransferCompletionHandler.class.cast(h2)).headers(map);
        }
        requestPacket.setConnection(ctx.getConnection());
        boolean isWriteComplete = true;
        if (payloadGenerator != null) {
            httpTxCtx.payloadGenerator = payloadGenerator;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            isWriteComplete = payloadGenerator.generate(ctx, request, requestPacket);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            ctx.write((Object)requestPacket, ctx.getTransportContext().getCompletionHandler());
        }
        return isWriteComplete;
    }

    private PayloadGenerator wrapWithExpectHandlerIfNeeded(PayloadGenerator payloadGenerator, HttpRequestPacket requestPacket) {
        if (payloadGenerator == null) {
            return null;
        }
        MimeHeaders headers = requestPacket.getHeaders();
        int expectHeaderIdx = headers.indexOf(Header.Expect, 0);
        return expectHeaderIdx != -1 && headers.getValue(expectHeaderIdx).equalsIgnoreCase("100-Continue") ? PayloadGenFactory.wrapWithExpect(payloadGenerator) : payloadGenerator;
    }

    private boolean isPayloadAllowed(Method method) {
        return method.getPayloadExpectation() != Method.PayloadExpectation.NOT_ALLOWED;
    }

    private void addAuthorizationHeader(Request req, HttpRequestPacket requestPacket, Realm realm, Uri uri, ProxyServer proxy, boolean isUsedConnection) throws IOException {
        String reqAuth;
        String conAuth;
        if (!isUsedConnection && (conAuth = AuthenticatorUtils.perConnectionAuthorizationHeader(req, uri, proxy, realm)) != null) {
            requestPacket.addHeader(Header.Authorization, conAuth);
        }
        if ((reqAuth = AuthenticatorUtils.perRequestAuthorizationHeader(req, uri, realm)) != null) {
            requestPacket.addHeader(Header.Authorization, reqAuth);
        }
    }

    private void addProxyHeaders(Request req, HttpRequestPacket requestPacket, Realm realm, ProxyServer proxy, boolean isUsedConnection, boolean isConnect) throws IOException {
        this.setKeepAliveForHeader(Header.ProxyConnection, requestPacket);
        this.setProxyAuthorizationHeader(req, requestPacket, proxy, realm, isUsedConnection, isConnect);
    }

    private void setProxyAuthorizationHeader(Request req, HttpRequestPacket requestPacket, ProxyServer proxy, Realm realm, boolean isUsedConnection, boolean isConnect) throws IOException {
        String conAuth;
        String reqAuth = AuthenticatorUtils.perRequestProxyAuthorizationHeader(req, realm, proxy, isConnect);
        if (reqAuth != null) {
            requestPacket.setHeader(Header.ProxyAuthorization, reqAuth);
            return;
        }
        if (!isUsedConnection && (conAuth = AuthenticatorUtils.perConnectionProxyAuthorizationHeader(req, proxy, isConnect)) != null) {
            requestPacket.setHeader(Header.ProxyAuthorization, conAuth);
        }
    }

    private void addHostHeaderIfNeeded(Request request, Uri uri, HttpRequestPacket requestPacket) {
        if (!requestPacket.containsHeader(Header.Host)) {
            String host = request.getVirtualHost();
            if (host != null) {
                requestPacket.addHeader(Header.Host, host);
            } else if (uri.getPort() == -1) {
                requestPacket.addHeader(Header.Host, uri.getHost());
            } else {
                requestPacket.addHeader(Header.Host, uri.getHost() + ':' + uri.getPort());
            }
        }
    }

    private Realm getRealm(Request request) {
        return request.getRealm() != null ? request.getRealm() : this.config.getRealm();
    }

    private String generateAuthHeader(Connection c, Realm realm) {
        try {
            switch (realm.getScheme()) {
                case BASIC: {
                    return AuthenticatorUtils.computeBasicAuthentication(realm);
                }
                case DIGEST: {
                    return AuthenticatorUtils.computeDigestAuthentication(realm);
                }
                case NTLM: {
                    return !Utils.getAndSetNtlmAttempted(c) ? "NTLM " + NTLM_INSTANCE_HOLDER.ntlmEngine.generateType1Msg() : null;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isUpgradeRequest(AsyncHandler handler) {
        return handler instanceof UpgradeHandler;
    }

    private boolean isWSRequest(Uri requestUri) {
        return requestUri.getScheme().startsWith("ws");
    }

    private void convertToUpgradeRequest(HttpTransactionContext ctx) {
        Uri requestUri;
        ctx.wsRequestURI = requestUri = ctx.requestUri;
        ctx.requestUri = requestUri.withNewScheme("ws".equals(requestUri.getScheme()) ? "http" : "https");
    }

    private void copyHeaders(Request request, HttpRequestPacket requestPacket) {
        FluentCaseInsensitiveStringsMap map = request.getHeaders();
        if (MiscUtils.isNonEmpty(map)) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String headerName = entry.getKey();
                List<String> headerValues = entry.getValue();
                if (!MiscUtils.isNonEmpty(headerValues)) continue;
                for (String headerValue : headerValues) {
                    requestPacket.addHeader(headerName, headerValue);
                }
            }
        }
    }

    private void addServiceHeaders(HttpRequestPacket requestPacket) {
        MimeHeaders headers = requestPacket.getHeaders();
        if (!headers.contains(Header.UserAgent)) {
            headers.addValue(Header.UserAgent).setString(this.config.getUserAgent());
        }
        this.setKeepAliveForHeader(Header.Connection, requestPacket);
    }

    private void setKeepAliveForHeader(Header header, HttpRequestPacket requestPacket) {
        MimeHeaders headers = requestPacket.getHeaders();
        if (!headers.contains(header)) {
            if (requestPacket.getProcessingState().isKeepAlive()) {
                headers.addValue(header).setBytes(KEEP_ALIVE_VALUE.getByteArray());
            } else if (Protocol.HTTP_1_1.equals((Object)requestPacket.getProtocol())) {
                headers.addValue(header).setBytes(CLOSE_VALUE.getByteArray());
            }
        }
    }

    private void addAcceptHeaders(HttpRequestPacket requestPacket) {
        MimeHeaders headers = requestPacket.getHeaders();
        if (this.config.isCompressionEnforced() && !headers.contains(Header.AcceptEncoding)) {
            headers.addValue(Header.AcceptEncoding).setString("gzip");
        }
        if (!headers.contains(Header.Accept)) {
            headers.addValue(Header.Accept).setString("*/*");
        }
    }

    private void addCookies(Request request, HttpRequestPacket requestPacket) {
        Collection<Cookie> cookies = request.getCookies();
        if (MiscUtils.isNonEmpty(cookies)) {
            StringBuilder sb = new StringBuilder(128);
            org.glassfish.grizzly.http.Cookie[] gCookies = new org.glassfish.grizzly.http.Cookie[cookies.size()];
            this.convertCookies(cookies, gCookies);
            CookieSerializerUtils.serializeClientCookies((StringBuilder)sb, (org.glassfish.grizzly.http.Cookie[])gCookies);
            requestPacket.addHeader(Header.Cookie, sb.toString());
        }
    }

    private void convertCookies(Collection<Cookie> cookies, org.glassfish.grizzly.http.Cookie[] gCookies) {
        int idx = 0;
        for (Cookie cookie : cookies) {
            gCookies[idx++] = new org.glassfish.grizzly.http.Cookie(cookie.getName(), cookie.getValue());
        }
    }

    private void setupKeepAlive(HttpRequestPacket request, Connection connection) {
        request.getProcessingState().setKeepAlive(ConnectionManager.isKeepAlive(connection));
    }

    private static class NTLM_INSTANCE_HOLDER {
        private static final NTLMEngine ntlmEngine = new NTLMEngine();

        private NTLM_INSTANCE_HOLDER() {
        }
    }
}

