/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.s3.base.config;

import com.amazonaws.auth.BasicAWSCredentials;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.runner.base.jackson.Obfuscate;
import java.util.Objects;

public class SingularityS3Credentials {
    private final String accessKey;
    private final String secretKey;

    @JsonCreator
    public SingularityS3Credentials(@JsonProperty(value="accessKey") String accessKey, @JsonProperty(value="secretKey") String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    @Obfuscate
    public String getAccessKey() {
        return this.accessKey;
    }

    @Obfuscate
    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityS3Credentials that = (SingularityS3Credentials)o;
        return Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessKey, this.secretKey);
    }

    public String toString() {
        return "SingularityS3Credentials[accessKey='" + JavaUtils.obfuscateValue(this.accessKey) + '\'' + ", secretKey='" + JavaUtils.obfuscateValue(this.secretKey) + '\'' + ']';
    }

    @JsonIgnore
    public BasicAWSCredentials toAWSCredentials() {
        return new BasicAWSCredentials(this.accessKey, this.secretKey);
    }
}

