/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.shared;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.hubspot.mesos.JavaUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WatchServiceHelper
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(WatchServiceHelper.class);
    private final WatchService watchService;
    private final Path watchDirectory;
    private final long pollWaitCheckShutdownMillis;
    private final List<WatchEvent.Kind<Path>> watchEvents;
    private volatile boolean stopped;

    public WatchServiceHelper(long pollWaitCheckShutdownMillis, Path watchDirectory, List<WatchEvent.Kind<Path>> watchEvents) {
        this.pollWaitCheckShutdownMillis = pollWaitCheckShutdownMillis;
        this.watchDirectory = watchDirectory;
        this.watchEvents = watchEvents;
        this.watchService = this.createWatchService();
        this.stopped = false;
    }

    public boolean stop() {
        if (this.stopped) {
            return false;
        }
        this.stopped = true;
        return true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    protected Path getWatchDirectory() {
        return this.watchDirectory;
    }

    @Override
    public void close() {
        try {
            Closeables.close(this.watchService, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private WatchService createWatchService() {
        try {
            return FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public void watch() throws IOException, InterruptedException {
        LOG.info("Watching directory {} for event(s) {}", (Object)this.watchDirectory, (Object)this.watchEvents);
        WatchKey watchKey = this.watchDirectory.register(this.watchService, this.watchEvents.toArray(new WatchEvent.Kind[this.watchEvents.size()]));
        while (!this.stopped) {
            if (watchKey != null) {
                this.processWatchKey(watchKey);
                if (!watchKey.reset()) {
                    LOG.warn("WatchKey for {} no longer valid", (Object)this.watchDirectory);
                    break;
                }
            }
            watchKey = this.watchService.poll(this.pollWaitCheckShutdownMillis, TimeUnit.MILLISECONDS);
        }
    }

    protected abstract boolean processEvent(WatchEvent.Kind<?> var1, Path var2) throws IOException;

    private WatchEvent<Path> cast(WatchEvent<?> event) {
        return event;
    }

    private void processWatchKey(WatchKey watchKey) throws IOException {
        long start = System.currentTimeMillis();
        List<WatchEvent<?>> events = watchKey.pollEvents();
        int processed = 0;
        for (WatchEvent<?> event : events) {
            WatchEvent.Kind<?> kind = event.kind();
            if (!this.watchEvents.contains(kind)) {
                LOG.trace("Ignoring an {} event to {}", event.context());
                continue;
            }
            WatchEvent<Path> ev = this.cast(event);
            Path filename = ev.context();
            if (!this.processEvent(kind, filename)) continue;
            ++processed;
        }
        LOG.debug("Handled {} out of {} event(s) for {} in {}", processed, events.size(), this.watchDirectory, JavaUtils.duration(start));
    }
}

