/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hubspot.singularity.runner.base.configuration.BaseRunnerConfiguration;
import com.hubspot.singularity.runner.base.configuration.Configuration;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SingularityRunnerBaseLogging {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityRunnerBaseLogging.class);
    private static final String[] CHATTY_LOGGERS = new String[]{"org.jboss.logging", "org.hibernate", "com.github.jknack.handlebars"};
    private final ObjectMapper yamlMapper;
    private final SingularityRunnerBaseConfiguration baseConfiguration;
    private final BaseRunnerConfiguration primaryConfiguration;
    private final Set<BaseRunnerConfiguration> configurations;
    private final Optional<String> consolidatedConfigFilename;
    private final String executorPid;

    public static void quietEagerLogging() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (String name : CHATTY_LOGGERS) {
            context.getLogger(name).setLevel(Level.WARN);
        }
    }

    @Inject
    public SingularityRunnerBaseLogging(@Named(value="obfuscated.yaml") ObjectMapper yamlMapper, SingularityRunnerBaseConfiguration baseConfiguration, BaseRunnerConfiguration primaryConfiguration, Set<BaseRunnerConfiguration> configurations, @Named(value="consolidated.config.filename") Optional<String> consolidatedConfigFilename, @Named(value="process.name") String executorPid) {
        this.yamlMapper = yamlMapper;
        this.primaryConfiguration = primaryConfiguration;
        this.configurations = configurations;
        this.baseConfiguration = baseConfiguration;
        this.consolidatedConfigFilename = consolidatedConfigFilename;
        this.executorPid = executorPid;
        this.configureRootLogger();
        this.printProperties();
    }

    public Optional<String> getRootLogPath() {
        if (this.primaryConfiguration.getLoggingFilename().isPresent()) {
            return Optional.of(Paths.get(this.primaryConfiguration.getLoggingDirectory().or(this.baseConfiguration.getLoggingDirectory()).or("/var/log/singularity/"), new String[0]).resolve(this.primaryConfiguration.getLoggingFilename().get()).toString());
        }
        return Optional.absent();
    }

    public void printProperties() {
        for (BaseRunnerConfiguration configuration : this.configurations) {
            try {
                Configuration annotation = configuration.getClass().getAnnotation(Configuration.class);
                String filename = this.consolidatedConfigFilename.or(annotation == null ? "(unknown)" : annotation.filename());
                LOG.trace(String.format("Loaded %s from %s:%n%s", configuration.getClass().getSimpleName(), filename, this.yamlMapper.writeValueAsString(configuration)));
            }
            catch (Exception e) {
                LOG.warn(String.format("Exception while attempting to print %s!", configuration.getClass().getName()), e);
            }
        }
    }

    public ch.qos.logback.classic.Logger prepareRootLogger(LoggerContext context) {
        ch.qos.logback.classic.Logger rootLogger = context.getLogger("ROOT");
        rootLogger.detachAndStopAllAppenders();
        return rootLogger;
    }

    public ch.qos.logback.classic.Logger configureRootLogger() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = this.prepareRootLogger(context);
        context.setName(this.executorPid);
        context.getLogger("ROOT").setLevel(Level.toLevel("INFO"));
        context.getLogger("com.hubspot").setLevel(Level.toLevel("INFO"));
        for (Map.Entry<String, String> entry : this.baseConfiguration.getLoggingLevel().entrySet()) {
            context.getLogger(entry.getKey()).setLevel(Level.toLevel(entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.primaryConfiguration.getLoggingLevel().entrySet()) {
            context.getLogger(entry.getKey()).setLevel(Level.toLevel(entry.getValue()));
        }
        if (this.getRootLogPath().isPresent()) {
            rootLogger.addAppender((Appender<ILoggingEvent>)this.buildFileAppender(context, this.getRootLogPath().get()));
        }
        return rootLogger;
    }

    public FileAppender<ILoggingEvent> buildFileAppender(LoggerContext context, String file) {
        FileAppender<ILoggingEvent> fileAppender = new FileAppender<ILoggingEvent>();
        fileAppender.setFile(file);
        fileAppender.setContext(context);
        fileAppender.setPrudent(true);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(context);
        encoder.setPattern(this.primaryConfiguration.getLoggingPattern().or(this.baseConfiguration.getLoggingPattern()).or("%-5level [%d] [%.15thread] %logger{35} - %msg%n"));
        encoder.start();
        fileAppender.setEncoder(encoder);
        fileAppender.start();
        return fileAppender;
    }
}

