/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.expiring;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.api.SingularityScaleRequest;
import com.hubspot.singularity.expiring.SingularityExpiringRequestActionParent;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Details about a scale action that will eventually revert")
public class SingularityExpiringScale
extends SingularityExpiringRequestActionParent<SingularityScaleRequest> {
    private final Optional<Integer> revertToInstances;
    private final Optional<Boolean> bounce;

    public SingularityExpiringScale(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="startMillis") long startMillis, @JsonProperty(value="expiringAPIRequestObject") SingularityScaleRequest scaleRequest, @JsonProperty(value="revertToInstances") Optional<Integer> revertToInstances, @JsonProperty(value="actionId") String actionId, @JsonProperty(value="bounce") Optional<Boolean> bounce) {
        super(scaleRequest, user, startMillis, actionId, requestId);
        this.revertToInstances = revertToInstances;
        this.bounce = bounce;
    }

    @Schema(description="The instance count to update to when time has elapsed", nullable=true)
    public Optional<Integer> getRevertToInstances() {
        return this.revertToInstances;
    }

    @Schema(description="If the scale action when updating instance count should also trigger a bounce", nullable=true, defaultValue="false")
    public Optional<Boolean> getBounce() {
        return this.bounce;
    }

    @Override
    public String toString() {
        return "SingularityExpiringScale{revertToInstances=" + this.revertToInstances + ", bounce=" + this.bounce + "} " + super.toString();
    }
}

