/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.singularity.SingularityS3UploaderFile;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Settings for a specific run of a request")
public class SingularityRunNowRequest {
    private final Optional<String> message;
    private final Optional<String> runId;
    private final Optional<List<String>> commandLineArgs;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<Resources> resources;
    private final List<SingularityS3UploaderFile> s3UploaderAdditionalFiles;
    private final Optional<String> runAsUserOverride;
    private final Map<String, String> envOverrides;
    private final List<SingularityMesosArtifact> extraArtifacts;
    private final Map<String, String> requiredSlaveAttributeOverrides;
    private final Map<String, String> allowedSlaveAttributeOverrides;
    private final Optional<Long> runAt;

    public SingularityRunNowRequest(Optional<String> message, Optional<Boolean> skipHealthchecks, Optional<String> runId, Optional<List<String>> commandLineArgs, Optional<Resources> resources) {
        this(message, skipHealthchecks, runId, commandLineArgs, resources, Collections.emptyList(), Optional.absent(), null, null, null, null, Optional.absent());
    }

    @Deprecated
    public SingularityRunNowRequest(Optional<String> message, Optional<Boolean> skipHealthchecks, Optional<String> runId, Optional<List<String>> commandLineArgs, Optional<Resources> resources, Optional<Long> runAt) {
        this(message, skipHealthchecks, runId, commandLineArgs, resources, Collections.emptyList(), Optional.absent(), null, null, null, null, runAt);
    }

    @JsonCreator
    public SingularityRunNowRequest(@JsonProperty(value="message") Optional<String> message, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="runId") Optional<String> runId, @JsonProperty(value="commandLineArgs") Optional<List<String>> commandLineArgs, @JsonProperty(value="resources") Optional<Resources> resources, @JsonProperty(value="s3UploaderAdditionalFiles") List<SingularityS3UploaderFile> s3UploaderAdditionalFiles, @JsonProperty(value="runAsUserOverride") Optional<String> runAsUserOverride, @JsonProperty(value="envOverrides") Map<String, String> envOverrides, @JsonProperty(value="requiredSlaveAttributeOverrides") Map<String, String> requiredSlaveAttributeOverrides, @JsonProperty(value="allowedSlaveAttributeOverrides") Map<String, String> allowedSlaveAttributeOverrides, @JsonProperty(value="extraArtifacts") List<SingularityMesosArtifact> extraArtifacts, @JsonProperty(value="runAt") Optional<Long> runAt) {
        this.message = message;
        this.commandLineArgs = commandLineArgs;
        this.runId = runId;
        this.skipHealthchecks = skipHealthchecks;
        this.resources = resources;
        this.s3UploaderAdditionalFiles = Objects.nonNull(s3UploaderAdditionalFiles) ? s3UploaderAdditionalFiles : Collections.emptyList();
        this.runAsUserOverride = runAsUserOverride;
        this.envOverrides = Objects.nonNull(envOverrides) ? envOverrides : Collections.emptyMap();
        this.requiredSlaveAttributeOverrides = Objects.nonNull(requiredSlaveAttributeOverrides) ? requiredSlaveAttributeOverrides : Collections.emptyMap();
        this.allowedSlaveAttributeOverrides = Objects.nonNull(allowedSlaveAttributeOverrides) ? allowedSlaveAttributeOverrides : Collections.emptyMap();
        this.extraArtifacts = Objects.nonNull(extraArtifacts) ? extraArtifacts : Collections.emptyList();
        this.runAt = runAt;
    }

    @Schema(description="A message to show to users about why this action was taken", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    @Schema(description="An id to associate with this request which will be associated with the corresponding launched tasks", nullable=true)
    public Optional<String> getRunId() {
        return this.runId;
    }

    @Schema(description="Command line arguments to be passed to the task", nullable=true)
    public Optional<List<String>> getCommandLineArgs() {
        return this.commandLineArgs;
    }

    @Schema(description="If set to true, healthchecks will be skipped for this task run", nullable=true)
    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    @Schema(description="Override the resources from the active deploy for this run", nullable=true)
    public Optional<Resources> getResources() {
        return this.resources;
    }

    @Schema(description="Specify additional sandbox files to upload to S3 for this run")
    public List<SingularityS3UploaderFile> getS3UploaderAdditionalFiles() {
        return this.s3UploaderAdditionalFiles;
    }

    @Schema(description="Override the user under which this task's command will be launched", nullable=true)
    public Optional<String> getRunAsUserOverride() {
        return this.runAsUserOverride;
    }

    @Schema(description="Override the environment variables for launched tasks")
    public Map<String, String> getEnvOverrides() {
        return this.envOverrides;
    }

    @Schema(description="Override the required slave attributes for launched tasks")
    public Map<String, String> getRequiredSlaveAttributeOverrides() {
        return this.requiredSlaveAttributeOverrides;
    }

    @Schema(description="Override the allowed slave attributes for launched tasks")
    public Map<String, String> getAllowedSlaveAttributeOverrides() {
        return this.allowedSlaveAttributeOverrides;
    }

    @Schema(description="Additional artifacts to download for this run")
    public List<SingularityMesosArtifact> getExtraArtifacts() {
        return this.extraArtifacts;
    }

    @Schema(description="Schedule this task to run at a specified time", nullable=true)
    public Optional<Long> getRunAt() {
        return this.runAt;
    }

    public String toString() {
        return "SingularityRunNowRequest{message=" + this.message + ", runId=" + this.runId + ", commandLineArgs=" + this.commandLineArgs + ", skipHealthchecks=" + this.skipHealthchecks + ", resources=" + this.resources + ", s3UploaderAdditionalFiles=" + this.s3UploaderAdditionalFiles + ", runAsUserOverride=" + this.runAsUserOverride + ", envOverrides=" + this.envOverrides + ", requiredSlaveAttributeOverrides=" + this.requiredSlaveAttributeOverrides + ", allowedSlaveAttributeOverrides=" + this.allowedSlaveAttributeOverrides + ", extraArtifacts=" + this.extraArtifacts + ", runAt=" + this.runAt + '}';
    }
}

