/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityShellCommand;
import com.hubspot.singularity.api.SingularityExpiringRequestParent;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Settings for how a pause should behave")
public class SingularityPauseRequest
extends SingularityExpiringRequestParent {
    private final Optional<Boolean> killTasks;
    private final Optional<SingularityShellCommand> runShellCommandBeforeKill;

    @JsonCreator
    public SingularityPauseRequest(@JsonProperty(value="killTasks") Optional<Boolean> killTasks, @JsonProperty(value="durationMillis") Optional<Long> durationMillis, @JsonProperty(value="actionId") Optional<String> actionId, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="runShellCommandBeforeKill") Optional<SingularityShellCommand> runShellCommandBeforeKill) {
        super(durationMillis, actionId, message);
        this.killTasks = killTasks;
        this.runShellCommandBeforeKill = runShellCommandBeforeKill;
    }

    @Schema(description="If set to false, tasks will be allowed to finish instead of killed immediately", nullable=true)
    public Optional<Boolean> getKillTasks() {
        return this.killTasks;
    }

    @Schema(description="Attempt to run this shell command on each task before it is shut down", nullable=true)
    public Optional<SingularityShellCommand> getRunShellCommandBeforeKill() {
        return this.runShellCommandBeforeKill;
    }

    @Override
    public String toString() {
        return "SingularityPauseRequest{killTasks=" + this.killTasks + ", runShellCommandBeforeKill=" + this.runShellCommandBeforeKill + "} " + super.toString();
    }
}

