/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Describes parameters to fetch the next page of results from s3")
public class ContinuationToken {
    private final String value;
    private final boolean lastPage;

    @JsonCreator
    public ContinuationToken(@JsonProperty(value="value") String value, @JsonProperty(value="lastPage") boolean lastPage) {
        this.value = value;
        this.lastPage = lastPage;
    }

    @Schema(required=true, description="S3 continuation token specific to a bucket + prefix being searched")
    public String getValue() {
        return this.value;
    }

    @Schema(required=true, description="If true, there are no further results for this bucket + prefix")
    public boolean isLastPage() {
        return this.lastPage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContinuationToken that = (ContinuationToken)o;
        return this.lastPage == that.lastPage && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.lastPage);
    }

    public String toString() {
        return "ContinuationToken{value='" + this.value + '\'' + ", lastPage=" + this.lastPage + '}';
    }
}

