/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityUser;
import com.hubspot.singularity.SingularityUserSettings;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Describes the attributes of a Singularity user")
public class SingularityUserHolder {
    private final Optional<SingularityUser> user;
    private final Optional<SingularityUserSettings> settings;
    private final boolean authenticated;
    private final boolean authEnabled;

    @JsonCreator
    public SingularityUserHolder(@JsonProperty(value="user") Optional<SingularityUser> user, @JsonProperty(value="settings") Optional<SingularityUserSettings> settings, @JsonProperty(value="authenticated") boolean authenticated, @JsonProperty(value="authEnabled") boolean authEnabled) {
        this.user = user;
        this.settings = settings;
        this.authenticated = authenticated;
        this.authEnabled = authEnabled;
    }

    @Schema(description="Information identifying this particular user")
    public Optional<SingularityUser> getUser() {
        return this.user;
    }

    @Schema(description="Settings for this particular user")
    public Optional<SingularityUserSettings> getSettings() {
        return this.settings;
    }

    @Schema(description="true if the user is authenticated")
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Schema(description="true if authentication is enabled")
    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String toString() {
        return "SingularityUserHolder{user=" + this.user + ", settings=" + this.settings + ", authenticated=" + this.authenticated + ", authEnabled=" + this.authEnabled + '}';
    }
}

