/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.annotations.media.Schema;
import java.security.Principal;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@Schema(description="Information about a user")
public class SingularityUser
implements Principal {
    private final String id;
    private final Optional<String> name;
    private final Optional<String> email;
    private final Set<String> groups;
    private final boolean authenticated;
    public static SingularityUser DEFAULT_USER = new SingularityUser("singularity", Optional.absent(), Optional.absent(), Collections.emptySet(), false);

    public SingularityUser(String id, Optional<String> name, Optional<String> email, Set<String> groups) {
        this(id, name, email, groups, true);
    }

    @JsonCreator
    public SingularityUser(@JsonProperty(value="id") String id, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="email") Optional<String> email, @JsonProperty(value="groups") Set<String> groups, @JsonProperty(value="authenticated") boolean authenticated) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.groups = ImmutableSet.copyOf(groups);
        this.authenticated = authenticated;
    }

    @Schema(description="The user's id")
    public String getId() {
        return this.id;
    }

    @Override
    @Schema(description="The user's name, or id if name not specified")
    public String getName() {
        return this.name.or(this.id);
    }

    @Schema(description="The user's email", nullable=true)
    public Optional<String> getEmail() {
        return this.email;
    }

    @Schema(description="Groups this user is a part of")
    public Set<String> getGroups() {
        return this.groups;
    }

    @Schema(description="True if the user was successfully authenticated")
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SingularityUser) {
            SingularityUser that = (SingularityUser)obj;
            return Objects.equals(this.authenticated, that.authenticated) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.email, that.email) && Objects.equals(this.groups, that.groups);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.email, this.groups, this.authenticated);
    }

    @Override
    public String toString() {
        return "SingularityUser{id='" + this.id + '\'' + ", name=" + this.name + ", email=" + this.email + ", groups=" + this.groups + ", authenticated=" + this.authenticated + '}';
    }
}

