/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Function;
import com.hubspot.singularity.SingularityKilledTaskIdRecord;
import com.hubspot.singularity.SingularityPendingDeploy;
import com.hubspot.singularity.SingularityPendingRequest;
import com.hubspot.singularity.SingularityPendingTask;
import com.hubspot.singularity.SingularityPendingTaskId;
import com.hubspot.singularity.SingularityRequestCleanup;
import com.hubspot.singularity.SingularityTask;
import com.hubspot.singularity.SingularityTaskCleanup;
import com.hubspot.singularity.SingularityTaskId;
import javax.annotation.Nonnull;

public class SingularityTransformHelpers {
    public static final Function<SingularityPendingRequest, String> PENDING_REQUEST_TO_REQUEST_ID = new Function<SingularityPendingRequest, String>(){

        @Override
        public String apply(@Nonnull SingularityPendingRequest input) {
            return input.getRequestId();
        }
    };
    public static final Function<SingularityRequestCleanup, String> REQUEST_CLEANUP_TO_REQUEST_ID = new Function<SingularityRequestCleanup, String>(){

        @Override
        public String apply(@Nonnull SingularityRequestCleanup input) {
            return input.getRequestId();
        }
    };
    public static final Function<SingularityTask, String> TASK_TO_REQUEST_ID = new Function<SingularityTask, String>(){

        @Override
        public String apply(@Nonnull SingularityTask input) {
            return input.getTaskRequest().getRequest().getId();
        }
    };
    public static final Function<SingularityPendingTask, String> PENDING_TASK_TO_REQUEST_ID = new Function<SingularityPendingTask, String>(){

        @Override
        public String apply(@Nonnull SingularityPendingTask input) {
            return input.getPendingTaskId().getRequestId();
        }
    };
    public static final Function<SingularityPendingTaskId, String> PENDING_TASK_ID_TO_REQUEST_ID = new Function<SingularityPendingTaskId, String>(){

        @Override
        public String apply(@Nonnull SingularityPendingTaskId input) {
            return input.getRequestId();
        }
    };
    public static final Function<SingularityTaskCleanup, String> TASK_CLEANUP_TO_REQUEST_ID = new Function<SingularityTaskCleanup, String>(){

        @Override
        public String apply(@Nonnull SingularityTaskCleanup input) {
            return input.getTaskId().getRequestId();
        }
    };
    public static final Function<SingularityTaskId, String> TASK_ID_TO_REQUEST_ID = new Function<SingularityTaskId, String>(){

        @Override
        public String apply(@Nonnull SingularityTaskId input) {
            return input.getRequestId();
        }
    };
    public static final Function<SingularityPendingDeploy, String> PENDING_DEPLOY_TO_REQUEST_ID = new Function<SingularityPendingDeploy, String>(){

        @Override
        public String apply(@Nonnull SingularityPendingDeploy input) {
            return input.getDeployMarker().getRequestId();
        }
    };
    public static final Function<SingularityKilledTaskIdRecord, String> KILLED_TASK_ID_RECORD_TO_REQUEST_ID = new Function<SingularityKilledTaskIdRecord, String>(){

        @Override
        public String apply(@Nonnull SingularityKilledTaskIdRecord input) {
            return input.getTaskId().getRequestId();
        }
    };

    private SingularityTransformHelpers() {
        throw new AssertionError((Object)"do not instantiate");
    }
}

