/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityUser;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Response containing the generated long lived auth token and associated user data")
public class SingularityTokenResponse {
    private final String token;
    private final SingularityUser user;

    @JsonCreator
    public SingularityTokenResponse(@JsonProperty(value="token") String token, @JsonProperty(value="user") SingularityUser user) {
        this.token = token;
        this.user = user;
    }

    @Schema(description="The generated/saved token", required=true)
    public String getToken() {
        return this.token;
    }

    @Schema(description="User data associated with the token", required=true)
    public SingularityUser getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTokenResponse that = (SingularityTokenResponse)o;
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        return this.user != null ? this.user.equals(that.user) : that.user == null;
    }

    public int hashCode() {
        int result = this.token != null ? this.token.hashCode() : 0;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SingularityTokenResponse{token='" + this.token + '\'' + ", user=" + this.user + '}';
    }
}

