/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityUser;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Request to create a new long lived auth token")
public class SingularityTokenRequest {
    private final Optional<String> token;
    private final Optional<SingularityUser> user;

    @JsonCreator
    public SingularityTokenRequest(@JsonProperty(value="token") Optional<String> token, @JsonProperty(value="user") Optional<SingularityUser> user) {
        this.token = token;
        this.user = user;
    }

    @Schema(description="Optional token, will be auto-genearted if not specified", required=false)
    public Optional<String> getToken() {
        return this.token;
    }

    @Schema(description="User data associated with the token, will be the current logged in user if not provided", required=true)
    public Optional<SingularityUser> getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTokenRequest that = (SingularityTokenRequest)o;
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        return this.user != null ? this.user.equals(that.user) : that.user == null;
    }

    public int hashCode() {
        int result = this.token != null ? this.token.hashCode() : 0;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SingularityTokenRequest{token=" + this.token + ", user=" + this.user + '}';
    }
}

