/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Current usage for a task")
public class SingularityTaskUsage {
    private final long memoryTotalBytes;
    private final long timestamp;
    private final double cpuSeconds;
    private final long diskTotalBytes;
    private final long cpusNrPeriods;
    private final long cpusNrThrottled;
    private final double cpusThrottledTimeSecs;

    @JsonCreator
    public SingularityTaskUsage(@JsonProperty(value="memoryTotalBytes") long memoryTotalBytes, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="cpuSeconds") double cpuSeconds, @JsonProperty(value="diskTotalBytes") long diskTotalBytes, @JsonProperty(value="cpusNrPeriods") long cpusNrPeriods, @JsonProperty(value="cpusNrThrottled") long cpusNrThrottled, @JsonProperty(value="cpusThrottledTimeSecs") double cpusThrottledTimeSecs) {
        this.memoryTotalBytes = memoryTotalBytes;
        this.timestamp = timestamp;
        this.cpuSeconds = cpuSeconds;
        this.diskTotalBytes = diskTotalBytes;
        this.cpusNrPeriods = cpusNrPeriods;
        this.cpusNrThrottled = cpusNrThrottled;
        this.cpusThrottledTimeSecs = cpusThrottledTimeSecs;
    }

    @Schema(description="Current total memory usage in bytes")
    public long getMemoryTotalBytes() {
        return this.memoryTotalBytes;
    }

    @Schema(description="Timestamp this usage was recorded (epoch millis)")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="Seconds of cpu time consumed by this task")
    public double getCpuSeconds() {
        return this.cpuSeconds;
    }

    @Schema(description="Total disk usage in bytes for this task")
    public long getDiskTotalBytes() {
        return this.diskTotalBytes;
    }

    @Schema(description="Number of cpu periods used by this task (from cgroups)")
    public long getCpusNrPeriods() {
        return this.cpusNrPeriods;
    }

    @Schema(description="Number of cpu periods throttled for this task (from cgroups)")
    public long getCpusNrThrottled() {
        return this.cpusNrThrottled;
    }

    @Schema(description="Total cpu time throttled for this task(from cgroups)")
    public double getCpusThrottledTimeSecs() {
        return this.cpusThrottledTimeSecs;
    }

    public String toString() {
        return "SingularityTaskUsage{memoryTotalBytes=" + this.memoryTotalBytes + ", timestamp=" + this.timestamp + ", cpuSeconds=" + this.cpuSeconds + ", diskTotalBytes=" + this.diskTotalBytes + ", cpusNrPeriods=" + this.cpusNrPeriods + ", cpusNrThrottled=" + this.cpusNrThrottled + ", cpusThrottledTimeSecs=" + this.cpusThrottledTimeSecs + '}';
    }
}

