/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityTaskId;

public class SingularityTaskShellCommandRequestId {
    private final SingularityTaskId taskId;
    private final String name;
    private final String safeName;
    private final long timestamp;

    @JsonCreator
    public SingularityTaskShellCommandRequestId(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="name") String name, @JsonProperty(value="timestamp") long timestamp) {
        this.taskId = taskId;
        this.timestamp = timestamp;
        this.name = name;
        this.safeName = name.replace("/", "");
    }

    @JsonIgnore
    public String getId() {
        return String.format("%s-%s", this.getTaskId(), this.getSubIdForTaskHistory());
    }

    @JsonIgnore
    public String getSubIdForTaskHistory() {
        return String.format("%s-%s", this.safeName, this.getTimestamp());
    }

    public SingularityTaskId getTaskId() {
        return this.taskId;
    }

    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingularityTaskShellCommandRequestId other = (SingularityTaskShellCommandRequestId)obj;
        return this.getId().equals(other.getId());
    }

    public String toString() {
        return "SingularityTaskShellCommandRequestId{taskId=" + this.taskId + ", name='" + this.name + '\'' + ", safeName='" + this.safeName + '\'' + ", timestamp=" + this.timestamp + "} " + super.toString();
    }
}

