/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityPendingTaskId;
import com.hubspot.singularity.SingularityTaskId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;

@Schema(description="Tasks in all states for a particular request")
public class SingularityTaskIdsByStatus {
    private List<SingularityTaskId> healthy;
    private List<SingularityTaskId> notYetHealthy;
    private List<SingularityPendingTaskId> pending;
    private List<SingularityTaskId> cleaning;

    @JsonCreator
    public SingularityTaskIdsByStatus(@JsonProperty(value="healthy") List<SingularityTaskId> healthy, @JsonProperty(value="notYetHealthy") List<SingularityTaskId> notYetHealthy, @JsonProperty(value="pending") List<SingularityPendingTaskId> pending, @JsonProperty(value="cleaning") List<SingularityTaskId> cleaning) {
        this.healthy = healthy;
        this.notYetHealthy = notYetHealthy;
        this.pending = pending;
        this.cleaning = cleaning;
    }

    @Schema(description="Active tasks whose healthchecks and load balancer updates (when applicable) have finished successfully")
    public List<SingularityTaskId> getHealthy() {
        return this.healthy;
    }

    @Schema(description="Active tasks whose healthchecks and load balancer updates (when applicable) have not yet finished successfully")
    public List<SingularityTaskId> getNotYetHealthy() {
        return this.notYetHealthy;
    }

    @Schema(description="Tasks that have not yet been launched")
    public List<SingularityPendingTaskId> getPending() {
        return this.pending;
    }

    @Schema(description="Active tasks in a cleaning state")
    public List<SingularityTaskId> getCleaning() {
        return this.cleaning;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SingularityTaskIdsByStatus) {
            SingularityTaskIdsByStatus that = (SingularityTaskIdsByStatus)obj;
            return Objects.equals(this.healthy, that.healthy) && Objects.equals(this.notYetHealthy, that.notYetHealthy) && Objects.equals(this.pending, that.pending) && Objects.equals(this.cleaning, that.cleaning);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthy, this.notYetHealthy, this.pending, this.cleaning);
    }

    public String toString() {
        return "SingularityTaskIdsByStatus{healthy=" + this.healthy + ", notYetHealthy=" + this.notYetHealthy + ", pending=" + this.pending + ", cleaning=" + this.cleaning + '}';
    }
}

