/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityTask;
import com.hubspot.singularity.SingularityTaskHistoryUpdate;
import com.hubspot.singularity.SingularityTaskId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Schema(description="A task id and latest state for a task")
public class SingularityTaskIdHistory
implements Comparable<SingularityTaskIdHistory> {
    private final SingularityTaskId taskId;
    private final long updatedAt;
    private final Optional<ExtendedTaskState> lastTaskState;
    private final Optional<String> runId;

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public static SingularityTaskIdHistory fromTaskIdAndTaskAndUpdates(SingularityTaskId taskId, SingularityTask task, List<SingularityTaskHistoryUpdate> updates) {
        ExtendedTaskState lastTaskState = null;
        long updatedAt = taskId.getStartedAt();
        if (updates != null && !updates.isEmpty()) {
            SingularityTaskHistoryUpdate lastUpdate = Collections.max(updates);
            lastTaskState = lastUpdate.getTaskState();
            updatedAt = lastUpdate.getTimestamp();
        }
        return new SingularityTaskIdHistory(taskId, updatedAt, Optional.fromNullable(lastTaskState), task.getTaskRequest().getPendingTask().getRunId());
    }

    @JsonCreator
    public SingularityTaskIdHistory(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="updatedAt") long updatedAt, @JsonProperty(value="lastStatus") Optional<ExtendedTaskState> lastTaskState, @JsonProperty(value="runId") Optional<String> runId) {
        this.taskId = taskId;
        this.updatedAt = updatedAt;
        this.lastTaskState = lastTaskState;
        this.runId = runId;
    }

    @Override
    public int compareTo(SingularityTaskIdHistory o) {
        return ComparisonChain.start().compare(o.getUpdatedAt(), this.updatedAt).compare((Comparable<?>)((Object)this.taskId.getId()), (Comparable<?>)((Object)o.getTaskId().getId())).result();
    }

    @Schema(description="Task id")
    public SingularityTaskId getTaskId() {
        return this.taskId;
    }

    @Schema(description="The latest state of the task", nullable=true)
    public Optional<ExtendedTaskState> getLastTaskState() {
        return this.lastTaskState;
    }

    @Schema(description="The timestamp of the latest update for the task")
    public long getUpdatedAt() {
        return this.updatedAt;
    }

    @Schema(description="A runId associated with this task", nullable=true)
    public Optional<String> getRunId() {
        return this.runId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTaskIdHistory that = (SingularityTaskIdHistory)o;
        return this.updatedAt == that.updatedAt && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.lastTaskState, that.lastTaskState) && Objects.equals(this.runId, that.runId);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.updatedAt, this.lastTaskState, this.runId);
    }

    public String toString() {
        return "SingularityTaskIdHistory{taskId=" + this.taskId + ", updatedAt=" + this.updatedAt + ", lastTaskState=" + this.lastTaskState + ", runId=" + this.runId + '}';
    }
}

