/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.InvalidSingularityTaskIdException;
import com.hubspot.singularity.SingularityHistoryItem;
import com.hubspot.singularity.SingularityId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;

@Schema(description="The unique id for a singularity task")
public class SingularityTaskId
extends SingularityId
implements SingularityHistoryItem {
    private final String requestId;
    private final String deployId;
    private final long startedAt;
    private final int instanceNo;
    private final String sanitizedHost;
    private final String sanitizedRackId;
    public static Comparator<SingularityTaskId> INSTANCE_NO_COMPARATOR = new Comparator<SingularityTaskId>(){

        @Override
        public int compare(SingularityTaskId o1, SingularityTaskId o2) {
            return Integer.compare(o1.instanceNo, o2.instanceNo);
        }
    };
    public static Comparator<SingularityTaskId> STARTED_AT_COMPARATOR_DESC = new Comparator<SingularityTaskId>(){

        @Override
        public int compare(SingularityTaskId o1, SingularityTaskId o2) {
            return Long.compare(o2.startedAt, o1.startedAt);
        }
    };

    public SingularityTaskId(String requestId, String deployId, long startedAt, int instanceNo, String sanitizedHost, String sanitizedRackId) {
        super(String.format("%s-%s-%s-%s-%s-%s", requestId, deployId, startedAt, instanceNo, sanitizedHost, sanitizedRackId));
        this.requestId = requestId;
        this.deployId = deployId;
        this.startedAt = startedAt;
        this.instanceNo = instanceNo;
        this.sanitizedHost = sanitizedHost;
        this.sanitizedRackId = sanitizedRackId;
    }

    @JsonCreator
    public SingularityTaskId(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="nextRunAt") Long nextRunAt, @JsonProperty(value="startedAt") Long startedAt, @JsonProperty(value="instanceNo") int instanceNo, @JsonProperty(value="host") String host, @JsonProperty(value="sanitizedHost") String sanitizedHost, @JsonProperty(value="sanitizedRackId") String sanitizedRackId, @JsonProperty(value="rackId") String rackId) {
        this(requestId, deployId, startedAt != null ? startedAt : nextRunAt, instanceNo, sanitizedHost != null ? sanitizedHost : host, sanitizedRackId != null ? sanitizedRackId : rackId);
    }

    @Deprecated
    @Schema(description="The id of the rack where this task was launched")
    public String getRackId() {
        return this.getSanitizedRackId();
    }

    @Schema(title="The id of the rack where this task was launched", description="- characters are repalced with _ in this id due to the fact that sections of the task id are delimited by -'s")
    public String getSanitizedRackId() {
        return this.sanitizedRackId;
    }

    @JsonIgnore
    public boolean matchesOriginalRackId(String unsanitizedRackId) {
        return this.sanitizedRackId.equals(JavaUtils.getReplaceHyphensWithUnderscores(unsanitizedRackId));
    }

    @Schema(description="The deploy associated with this task")
    public String getDeployId() {
        return this.deployId;
    }

    @Deprecated
    @Schema(description="The hostname of the machine where this task was launched")
    public String getHost() {
        return this.getSanitizedHost();
    }

    @Schema(title="The hostname of the machine where this task was launched", description="- characters are repalced with _ in this id due to the fact that sections of the task id are delimited by -'s")
    public String getSanitizedHost() {
        return this.sanitizedHost;
    }

    @JsonIgnore
    public boolean matchesOriginalHost(String unsanitizedHost) {
        return this.sanitizedHost.equals(JavaUtils.getReplaceHyphensWithUnderscores(unsanitizedHost));
    }

    @Schema(description="The request associated with this task")
    public String getRequestId() {
        return this.requestId;
    }

    @Schema(description="The time at which this task was started")
    public long getStartedAt() {
        return this.startedAt;
    }

    @Schema(description="The instance number for this task", minimum="1")
    public int getInstanceNo() {
        return this.instanceNo;
    }

    @Override
    @JsonIgnore
    public long getCreateTimestampForCalculatingHistoryAge() {
        return this.getStartedAt();
    }

    public static SingularityTaskId valueOf(String string) throws InvalidSingularityTaskIdException {
        String[] splits = null;
        try {
            splits = JavaUtils.reverseSplit(string, 6, "-");
        }
        catch (IllegalStateException ise) {
            throw new InvalidSingularityTaskIdException(String.format("TaskId %s was invalid (%s)", string, ise.getMessage()));
        }
        try {
            String requestId = splits[0];
            String deployId = splits[1];
            long startedAt = Long.parseLong(splits[2]);
            int instanceNo = Integer.parseInt(splits[3]);
            String host = splits[4];
            String rackId = splits[5];
            return new SingularityTaskId(requestId, deployId, startedAt, instanceNo, host, rackId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSingularityTaskIdException(String.format("TaskId %s had an invalid parameter (%s)", string, e.getMessage()));
        }
    }

    public String toString() {
        return this.getId();
    }
}

