/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.OrderDirection;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHistory;
import java.util.Comparator;

public class SingularityTaskHistoryQuery {
    private final Optional<String> requestId;
    private final Optional<String> deployId;
    private final Optional<String> runId;
    private final Optional<String> host;
    private final Optional<ExtendedTaskState> lastTaskStatus;
    private final Optional<Long> startedBefore;
    private final Optional<Long> startedAfter;
    private final Optional<Long> updatedBefore;
    private final Optional<Long> updatedAfter;
    private final Optional<OrderDirection> orderDirection;

    public SingularityTaskHistoryQuery(String requestId) {
        this(Optional.of(requestId), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent());
    }

    public SingularityTaskHistoryQuery(Optional<String> requestId, Optional<String> deployId, Optional<String> runId, Optional<String> host, Optional<ExtendedTaskState> lastTaskStatus, Optional<Long> startedBefore, Optional<Long> startedAfter, Optional<Long> updatedBefore, Optional<Long> updatedAfter, Optional<OrderDirection> orderDirection) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.runId = runId;
        this.host = host;
        this.lastTaskStatus = lastTaskStatus;
        this.startedBefore = startedBefore;
        this.startedAfter = startedAfter;
        this.updatedBefore = updatedBefore;
        this.updatedAfter = updatedAfter;
        this.orderDirection = orderDirection;
    }

    public Optional<String> getRequestId() {
        return this.requestId;
    }

    public Optional<String> getDeployId() {
        return this.deployId;
    }

    public Optional<String> getRunId() {
        return this.runId;
    }

    public Optional<String> getHost() {
        return this.host;
    }

    public Optional<ExtendedTaskState> getLastTaskStatus() {
        return this.lastTaskStatus;
    }

    public Optional<Long> getStartedBefore() {
        return this.startedBefore;
    }

    public Optional<Long> getStartedAfter() {
        return this.startedAfter;
    }

    public Optional<Long> getUpdatedBefore() {
        return this.updatedBefore;
    }

    public Optional<Long> getUpdatedAfter() {
        return this.updatedAfter;
    }

    public Optional<OrderDirection> getOrderDirection() {
        return this.orderDirection;
    }

    public Predicate<SingularityTaskIdHistory> getHistoryFilter() {
        return new Predicate<SingularityTaskIdHistory>(){

            @Override
            public boolean apply(SingularityTaskIdHistory input) {
                SingularityTaskId taskId = input.getTaskId();
                if (SingularityTaskHistoryQuery.this.requestId.isPresent() && !((String)SingularityTaskHistoryQuery.this.requestId.get()).equals(taskId.getRequestId())) {
                    return false;
                }
                if (SingularityTaskHistoryQuery.this.host.isPresent() && !((String)SingularityTaskHistoryQuery.this.host.get()).equals(taskId.getHost())) {
                    return false;
                }
                if (SingularityTaskHistoryQuery.this.deployId.isPresent() && !((String)SingularityTaskHistoryQuery.this.deployId.get()).equals(taskId.getDeployId())) {
                    return false;
                }
                if (SingularityTaskHistoryQuery.this.runId.isPresent() && !((String)SingularityTaskHistoryQuery.this.runId.get()).equals(input.getRunId().or(""))) {
                    return false;
                }
                if (SingularityTaskHistoryQuery.this.lastTaskStatus.isPresent()) {
                    if (!input.getLastTaskState().isPresent()) {
                        return false;
                    }
                    if (SingularityTaskHistoryQuery.this.lastTaskStatus.get() != input.getLastTaskState().get()) {
                        return false;
                    }
                }
                if (SingularityTaskHistoryQuery.this.startedAfter.isPresent() && (Long)SingularityTaskHistoryQuery.this.startedAfter.get() >= taskId.getStartedAt()) {
                    return false;
                }
                if (SingularityTaskHistoryQuery.this.startedBefore.isPresent() && (Long)SingularityTaskHistoryQuery.this.startedBefore.get() <= taskId.getStartedAt()) {
                    return false;
                }
                if (SingularityTaskHistoryQuery.this.updatedAfter.isPresent() && (Long)SingularityTaskHistoryQuery.this.updatedAfter.get() >= input.getUpdatedAt()) {
                    return false;
                }
                return !SingularityTaskHistoryQuery.this.updatedBefore.isPresent() || (Long)SingularityTaskHistoryQuery.this.updatedBefore.get() > input.getUpdatedAt();
            }
        };
    }

    public Comparator<SingularityTaskIdHistory> getComparator() {
        final OrderDirection localOrderDirection = this.orderDirection.or(OrderDirection.DESC);
        return new Comparator<SingularityTaskIdHistory>(){

            @Override
            public int compare(SingularityTaskIdHistory o1, SingularityTaskIdHistory o2) {
                ComparisonChain chain = ComparisonChain.start();
                chain = localOrderDirection == OrderDirection.ASC ? chain.compare(o1.getTaskId().getStartedAt(), o2.getTaskId().getStartedAt()) : chain.compare(o2.getTaskId().getStartedAt(), o1.getTaskId().getStartedAt());
                return chain.compare((Comparable<?>)((Object)o1.getTaskId().getRequestId()), (Comparable<?>)((Object)o2.getTaskId().getRequestId())).result();
            }
        };
    }

    public String toString() {
        return "SingularityTaskHistoryQuery{requestId=" + this.requestId + ", deployId=" + this.deployId + ", runId=" + this.runId + ", host=" + this.host + ", lastTaskStatus=" + this.lastTaskStatus + ", startedBefore=" + this.startedBefore + ", startedAfter=" + this.startedAfter + ", updatedBefore=" + this.updatedBefore + ", updatedAfter=" + this.updatedAfter + ", orderDirection=" + this.orderDirection + '}';
    }
}

