/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.SingularityLoadBalancerUpdate;
import com.hubspot.singularity.SingularityTask;
import com.hubspot.singularity.SingularityTaskHealthcheckResult;
import com.hubspot.singularity.SingularityTaskHistoryUpdate;
import com.hubspot.singularity.SingularityTaskMetadata;
import com.hubspot.singularity.SingularityTaskShellCommandHistory;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Describes the full history of a Singularity task")
public class SingularityTaskHistory {
    private final List<SingularityTaskHistoryUpdate> taskUpdates;
    private final Optional<String> directory;
    private final Optional<String> containerId;
    private final SingularityTask task;
    private final List<SingularityTaskHealthcheckResult> healthcheckResults;
    private final List<SingularityLoadBalancerUpdate> loadBalancerUpdates;
    private final List<SingularityTaskShellCommandHistory> shellCommandHistory;
    private final List<SingularityTaskMetadata> taskMetadata;

    @JsonCreator
    public SingularityTaskHistory(@JsonProperty(value="taskUpdates") List<SingularityTaskHistoryUpdate> taskUpdates, @JsonProperty(value="directory") Optional<String> directory, @JsonProperty(value="containerId") Optional<String> containerId, @JsonProperty(value="healthcheckResults") List<SingularityTaskHealthcheckResult> healthcheckResults, @JsonProperty(value="task") SingularityTask task, @JsonProperty(value="loadBalancerUpdates") List<SingularityLoadBalancerUpdate> loadBalancerUpdates, @JsonProperty(value="shellCommandHistory") List<SingularityTaskShellCommandHistory> shellCommandHistory, @JsonProperty(value="taskMetadata") List<SingularityTaskMetadata> taskMetadata) {
        this.directory = directory;
        this.containerId = containerId;
        this.task = task;
        this.taskUpdates = JavaUtils.nonNullImmutable(taskUpdates);
        this.healthcheckResults = JavaUtils.nonNullImmutable(healthcheckResults);
        this.loadBalancerUpdates = JavaUtils.nonNullImmutable(loadBalancerUpdates);
        this.shellCommandHistory = JavaUtils.nonNullImmutable(shellCommandHistory);
        this.taskMetadata = JavaUtils.nonNullImmutable(taskMetadata);
    }

    @Schema(description="A list of status updates for this task")
    public List<SingularityTaskHistoryUpdate> getTaskUpdates() {
        return this.taskUpdates;
    }

    @Schema(description="The directory of the task sandbox on teh mesos slave", nullable=true)
    public Optional<String> getDirectory() {
        return this.directory;
    }

    @Schema(description="If a docker task, the docker container id", nullable=true)
    public Optional<String> getContainerId() {
        return this.containerId;
    }

    @Schema(description="Full Singularity task data")
    public SingularityTask getTask() {
        return this.task;
    }

    @Schema(description="A list of custom metadata associated with this task")
    public List<SingularityTaskMetadata> getTaskMetadata() {
        return this.taskMetadata;
    }

    @Schema(description="Healthcheck results for this task")
    public List<SingularityTaskHealthcheckResult> getHealthcheckResults() {
        return this.healthcheckResults;
    }

    @Schema(description="A list of load balancer updates for this task")
    public List<SingularityLoadBalancerUpdate> getLoadBalancerUpdates() {
        return this.loadBalancerUpdates;
    }

    @Schema(description="A list of shell commands that have been run against this task")
    public List<SingularityTaskShellCommandHistory> getShellCommandHistory() {
        return this.shellCommandHistory;
    }

    @JsonIgnore
    public Optional<SingularityTaskHistoryUpdate> getLastTaskUpdate() {
        return JavaUtils.getLast(this.getTaskUpdates());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTaskHistory that = (SingularityTaskHistory)o;
        if (this.taskUpdates != null ? !this.taskUpdates.equals(that.taskUpdates) : that.taskUpdates != null) {
            return false;
        }
        if (this.directory != null ? !this.directory.equals(that.directory) : that.directory != null) {
            return false;
        }
        if (this.containerId != null ? !this.containerId.equals(that.containerId) : that.containerId != null) {
            return false;
        }
        if (this.task != null ? !this.task.equals(that.task) : that.task != null) {
            return false;
        }
        if (this.healthcheckResults != null ? !this.healthcheckResults.equals(that.healthcheckResults) : that.healthcheckResults != null) {
            return false;
        }
        if (this.loadBalancerUpdates != null ? !this.loadBalancerUpdates.equals(that.loadBalancerUpdates) : that.loadBalancerUpdates != null) {
            return false;
        }
        if (this.shellCommandHistory != null ? !this.shellCommandHistory.equals(that.shellCommandHistory) : that.shellCommandHistory != null) {
            return false;
        }
        return this.taskMetadata != null ? this.taskMetadata.equals(that.taskMetadata) : that.taskMetadata == null;
    }

    public int hashCode() {
        int result = this.taskUpdates != null ? this.taskUpdates.hashCode() : 0;
        result = 31 * result + (this.directory != null ? this.directory.hashCode() : 0);
        result = 31 * result + (this.containerId != null ? this.containerId.hashCode() : 0);
        result = 31 * result + (this.task != null ? this.task.hashCode() : 0);
        result = 31 * result + (this.healthcheckResults != null ? this.healthcheckResults.hashCode() : 0);
        result = 31 * result + (this.loadBalancerUpdates != null ? this.loadBalancerUpdates.hashCode() : 0);
        result = 31 * result + (this.shellCommandHistory != null ? this.shellCommandHistory.hashCode() : 0);
        result = 31 * result + (this.taskMetadata != null ? this.taskMetadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SingularityTaskHistory{taskUpdates=" + this.taskUpdates + ", directory=" + this.directory + ", containerId=" + this.containerId + ", task=" + this.task + ", healthcheckResults=" + this.healthcheckResults + ", loadBalancerUpdates=" + this.loadBalancerUpdates + ", shellCommandHistory=" + this.shellCommandHistory + ", taskMetadata=" + this.taskMetadata + '}';
    }
}

