/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityDeployMarker;
import com.hubspot.singularity.SingularityHostState;
import com.hubspot.singularity.SingularityPendingTaskId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;

@Schema(description="Describes the current state of singularity")
public class SingularityState {
    private final int activeTasks;
    private final int launchingTasks;
    private final int pausedRequests;
    private final int activeRequests;
    private final int cooldownRequests;
    private final int scheduledTasks;
    private final int lateTasks;
    private final List<SingularityPendingTaskId> listLateTasks;
    private final int onDemandLateTasks;
    private final List<SingularityPendingTaskId> onDemandListLateTasks;
    private final int futureTasks;
    private final int cleaningTasks;
    private final int lbCleanupTasks;
    private final int lbCleanupRequests;
    private final long maxTaskLag;
    private final int pendingRequests;
    private final int cleaningRequests;
    private final int finishedRequests;
    private final int activeSlaves;
    private final int deadSlaves;
    private final int decommissioningSlaves;
    private final int unknownSlaves;
    private final int activeRacks;
    private final int deadRacks;
    private final int decommissioningRacks;
    private final int unknownRacks;
    private final long oldestDeploy;
    private final int numDeploys;
    private final long oldestDeployStep;
    private final List<SingularityDeployMarker> activeDeploys;
    private final long generatedAt;
    private final List<SingularityHostState> hostStates;
    private final List<String> overProvisionedRequestIds;
    private final List<String> underProvisionedRequestIds;
    private final int overProvisionedRequests;
    private final int underProvisionedRequests;
    private final Optional<Boolean> authDatastoreHealthy;
    private final Optional<Double> minimumPriorityLevel;
    private final long avgStatusUpdateDelayMs;
    private final long lastHeartbeatAt;

    @JsonCreator
    public SingularityState(@JsonProperty(value="activeTasks") int activeTasks, @JsonProperty(value="launchingTasks") int launchingTasks, @JsonProperty(value="activeRequests") int activeRequests, @JsonProperty(value="cooldownRequests") int cooldownRequests, @JsonProperty(value="pausedRequests") int pausedRequests, @JsonProperty(value="scheduledTasks") int scheduledTasks, @JsonProperty(value="pendingRequests") int pendingRequests, @JsonProperty(value="lbCleanupTasks") int lbCleanupTasks, @JsonProperty(value="lbCleanupRequests") int lbCleanupRequests, @JsonProperty(value="cleaningRequests") int cleaningRequests, @JsonProperty(value="activeSlaves") int activeSlaves, @JsonProperty(value="deadSlaves") int deadSlaves, @JsonProperty(value="decommissioningSlaves") int decommissioningSlaves, @JsonProperty(value="activeRacks") int activeRacks, @JsonProperty(value="deadRacks") int deadRacks, @JsonProperty(value="decommissioningRacks") int decommissioningRacks, @JsonProperty(value="cleaningTasks") int cleaningTasks, @JsonProperty(value="hostStates") List<SingularityHostState> hostStates, @JsonProperty(value="oldestDeploy") long oldestDeploy, @JsonProperty(value="numDeploys") int numDeploys, @JsonProperty(value="oldestDeployStep") long oldestDeployStep, @JsonProperty(value="activeDeploys") List<SingularityDeployMarker> activeDeploys, @JsonProperty(value="lateTasks") int lateTasks, @JsonProperty(value="listLateTasks") List<SingularityPendingTaskId> listLateTasks, @JsonProperty(value="onDemandLateTasks") int onDemandLateTasks, @JsonProperty(value="onDemandListLateTasks") List<SingularityPendingTaskId> onDemandListLateTasks, @JsonProperty(value="futureTasks") int futureTasks, @JsonProperty(value="maxTaskLag") long maxTaskLag, @JsonProperty(value="generatedAt") long generatedAt, @JsonProperty(value="overProvisionedRequestIds") List<String> overProvisionedRequestIds, @JsonProperty(value="underProvisionedRequestIds") List<String> underProvisionedRequestIds, @JsonProperty(value="overProvisionedRequests") int overProvisionedRequests, @JsonProperty(value="underProvisionedRequests") int underProvisionedRequests, @JsonProperty(value="finishedRequests") int finishedRequests, @JsonProperty(value="unknownRacks") int unknownRacks, @JsonProperty(value="unknownSlaves") int unknownSlaves, @JsonProperty(value="authDatastoreHealthy") Optional<Boolean> authDatastoreHealthy, @JsonProperty(value="minimumPriorityLevel") Optional<Double> minimumPriorityLevel, @JsonProperty(value="avgStatusUpdateDelayMs") long avgStatusUpdateDelayMs, @JsonProperty(value="lastHeartbeatAt") long lastHeartbeatAt) {
        this.activeTasks = activeTasks;
        this.launchingTasks = launchingTasks;
        this.activeRequests = activeRequests;
        this.pausedRequests = pausedRequests;
        this.cooldownRequests = cooldownRequests;
        this.scheduledTasks = scheduledTasks;
        this.pendingRequests = pendingRequests;
        this.cleaningRequests = cleaningRequests;
        this.activeRacks = activeRacks;
        this.generatedAt = generatedAt;
        this.activeSlaves = activeSlaves;
        this.deadRacks = deadRacks;
        this.deadSlaves = deadSlaves;
        this.unknownSlaves = unknownSlaves;
        this.unknownRacks = unknownRacks;
        this.decommissioningRacks = decommissioningRacks;
        this.decommissioningSlaves = decommissioningSlaves;
        this.cleaningTasks = cleaningTasks;
        this.hostStates = hostStates;
        this.lateTasks = lateTasks;
        this.listLateTasks = listLateTasks == null ? Collections.emptyList() : listLateTasks;
        this.onDemandLateTasks = onDemandLateTasks;
        this.onDemandListLateTasks = onDemandListLateTasks == null ? Collections.emptyList() : onDemandListLateTasks;
        this.finishedRequests = finishedRequests;
        this.futureTasks = futureTasks;
        this.maxTaskLag = maxTaskLag;
        this.oldestDeploy = oldestDeploy;
        this.numDeploys = numDeploys;
        this.oldestDeployStep = oldestDeployStep;
        this.activeDeploys = activeDeploys;
        this.lbCleanupTasks = lbCleanupTasks;
        this.lbCleanupRequests = lbCleanupRequests;
        this.underProvisionedRequests = underProvisionedRequests;
        this.overProvisionedRequests = overProvisionedRequests;
        this.overProvisionedRequestIds = overProvisionedRequestIds;
        this.underProvisionedRequestIds = underProvisionedRequestIds;
        this.authDatastoreHealthy = authDatastoreHealthy;
        this.minimumPriorityLevel = minimumPriorityLevel;
        this.avgStatusUpdateDelayMs = avgStatusUpdateDelayMs;
        this.lastHeartbeatAt = lastHeartbeatAt;
    }

    @Schema(description="Count of requests in finished state")
    public int getFinishedRequests() {
        return this.finishedRequests;
    }

    @Schema(description="Time this state was generated")
    public long getGeneratedAt() {
        return this.generatedAt;
    }

    @Schema(description="Timestamp of the oldest running deploy")
    public long getOldestDeploy() {
        return this.oldestDeploy;
    }

    @Schema(description="Number of active/in-progress deploys")
    public int getNumDeploys() {
        return this.numDeploys;
    }

    @Schema(title="Timestamp of the oldest single step for a deploy", description="For incremental deploys this is a measure of the time taken for a single step of the deploy")
    public long getOldestDeployStep() {
        return this.oldestDeployStep;
    }

    @Schema(description="List of active deploy identifiers")
    public List<SingularityDeployMarker> getActiveDeploys() {
        return this.activeDeploys;
    }

    @Schema(description="Count of requests in paused state")
    public int getPausedRequests() {
        return this.pausedRequests;
    }

    @Schema(description="Describes the state of all Singularity scheduler instances")
    public List<SingularityHostState> getHostStates() {
        return this.hostStates;
    }

    @Schema(description="The count of cleaning tasks")
    public int getCleaningTasks() {
        return this.cleaningTasks;
    }

    @Schema(description="The count of active slaves")
    public int getActiveSlaves() {
        return this.activeSlaves;
    }

    @Schema(description="The count of dead slaves (no longer reachable or considered lost by mesos)")
    public int getDeadSlaves() {
        return this.deadSlaves;
    }

    @Schema(description="The count of slaves currently decommissioning")
    public int getDecommissioningSlaves() {
        return this.decommissioningSlaves;
    }

    @Deprecated
    @Schema(description="The count of slaves currently decommissioning")
    public int getDecomissioningSlaves() {
        return this.decommissioningSlaves;
    }

    @Schema(description="The count of active racks")
    public int getActiveRacks() {
        return this.activeRacks;
    }

    @Schema(description="The count of racks considered dead")
    public int getDeadRacks() {
        return this.deadRacks;
    }

    @Deprecated
    @Schema(description="The count of racks that are currently decommissioning")
    public int getDecomissioningRacks() {
        return this.decommissioningRacks;
    }

    @Schema(description="The count of racks that are currently decommissioning")
    public int getDecommissioningRacks() {
        return this.decommissioningRacks;
    }

    @Schema(description="The count of active tasks")
    public int getActiveTasks() {
        return this.activeTasks;
    }

    @Schema(description="The count of tasks in launching state")
    public int getLaunchingTasks() {
        return this.launchingTasks;
    }

    @Schema(description="The count of all requests in all states")
    public int getAllRequests() {
        return this.activeRequests + this.cooldownRequests + this.pausedRequests;
    }

    @Schema(description="The count of requests in active state")
    public int getActiveRequests() {
        return this.activeRequests;
    }

    @Schema(description="The count of requests in cooldown state")
    public int getCooldownRequests() {
        return this.cooldownRequests;
    }

    @Schema(description="The count of tasks waiting to be launched")
    public int getScheduledTasks() {
        return this.scheduledTasks;
    }

    @Schema(title="The count of pending requests", description="A pending request is a trigger for the scheduler to perform an action for a request (create a cleanup, launch a task, etc)")
    public int getPendingRequests() {
        return this.pendingRequests;
    }

    @Schema(description="The count of requests with associated cleanups (e.g. due to a bounce)")
    public int getCleaningRequests() {
        return this.cleaningRequests;
    }

    @Schema(description="The count of tasks that have not been launched in time, excluding the on-demand tasks")
    public int getLateTasks() {
        return this.lateTasks;
    }

    @Schema(description="The list of all late tasks that have not been launched in time, excluding the on-demand tasks")
    public List<SingularityPendingTaskId> getListLateTasks() {
        return this.listLateTasks;
    }

    @Schema(description="The count of on-demand tasks that have not been launched in time")
    public int getOnDemandLateTasks() {
        return this.onDemandLateTasks;
    }

    @Schema(description="The list of all on-demand late tasks that have not been launched in time")
    public List<SingularityPendingTaskId> getOnDemandListLateTasks() {
        return this.onDemandListLateTasks;
    }

    @Schema(description="The count of pending tasks that will be launched at a future time")
    public int getFutureTasks() {
        return this.futureTasks;
    }

    @Schema(description="The maximum delay in launching any pending task")
    public long getMaxTaskLag() {
        return this.maxTaskLag;
    }

    @Schema(description="The count of tasks with associated load balancer cleanups")
    public int getLbCleanupTasks() {
        return this.lbCleanupTasks;
    }

    @Schema(description="The count of requests with associated load balancer cleanups")
    public int getLbCleanupRequests() {
        return this.lbCleanupRequests;
    }

    @Schema(description="The count of requests running too many instances")
    public List<String> getOverProvisionedRequestIds() {
        return this.overProvisionedRequestIds;
    }

    @Schema(description="The ids of requests running too many instances")
    public List<String> getUnderProvisionedRequestIds() {
        return this.underProvisionedRequestIds;
    }

    @Schema(description="The count of requests running too few instances")
    public int getOverProvisionedRequests() {
        return this.overProvisionedRequests;
    }

    @Schema(description="The ids of requests running too few instances")
    public int getUnderProvisionedRequests() {
        return this.underProvisionedRequests;
    }

    @Schema(description="The count of slaves in an unknown state")
    public int getUnknownSlaves() {
        return this.unknownSlaves;
    }

    @Schema(description="The count of racks in an unknown state")
    public int getUnknownRacks() {
        return this.unknownRacks;
    }

    @Schema(description="`true` if the auth datastore is reachable (when auth is configured)", nullable=true)
    public Optional<Boolean> getAuthDatastoreHealthy() {
        return this.authDatastoreHealthy;
    }

    @Schema(description="The minimum priority level for launching tasks if a priority freeze is active, empty otherwise", nullable=true)
    public Optional<Double> getMinimumPriorityLevel() {
        return this.minimumPriorityLevel;
    }

    @Schema(description="The average delay (in millis) for processing status updates from mesos")
    public long getAvgStatusUpdateDelayMs() {
        return this.avgStatusUpdateDelayMs;
    }

    @Schema(description="Time in UTC millis at which Singularity received the most recent HEARTBEAT event from the Mesos Master")
    public long getLastHeartbeatAt() {
        return this.lastHeartbeatAt;
    }

    public String toString() {
        return "SingularityState{activeTasks=" + this.activeTasks + ", launchingTasks=" + this.launchingTasks + ", pausedRequests=" + this.pausedRequests + ", activeRequests=" + this.activeRequests + ", cooldownRequests=" + this.cooldownRequests + ", scheduledTasks=" + this.scheduledTasks + ", lateTasks=" + this.lateTasks + ", listLateTasks=" + this.listLateTasks + ", onDemandLateTasks=" + this.onDemandLateTasks + ", onDemandListLateTasks=" + this.onDemandListLateTasks + ", futureTasks=" + this.futureTasks + ", cleaningTasks=" + this.cleaningTasks + ", lbCleanupTasks=" + this.lbCleanupTasks + ", lbCleanupRequests=" + this.lbCleanupRequests + ", maxTaskLag=" + this.maxTaskLag + ", pendingRequests=" + this.pendingRequests + ", cleaningRequests=" + this.cleaningRequests + ", finishedRequests=" + this.finishedRequests + ", activeSlaves=" + this.activeSlaves + ", deadSlaves=" + this.deadSlaves + ", decommissioningSlaves=" + this.decommissioningSlaves + ", unknownSlaves=" + this.unknownSlaves + ", activeRacks=" + this.activeRacks + ", deadRacks=" + this.deadRacks + ", decommissioningRacks=" + this.decommissioningRacks + ", unknownRacks=" + this.unknownRacks + ", oldestDeploy=" + this.oldestDeploy + ", numDeploys=" + this.numDeploys + ", oldestDeployStep=" + this.oldestDeployStep + ", activeDeploys=" + this.activeDeploys + ", generatedAt=" + this.generatedAt + ", hostStates=" + this.hostStates + ", overProvisionedRequestIds=" + this.overProvisionedRequestIds + ", underProvisionedRequestIds=" + this.underProvisionedRequestIds + ", overProvisionedRequests=" + this.overProvisionedRequests + ", underProvisionedRequests=" + this.underProvisionedRequests + ", authDatastoreHealthy=" + this.authDatastoreHealthy + ", minimumPriorityLevel=" + this.minimumPriorityLevel + ", avgStatusUpdateDelayMs=" + this.avgStatusUpdateDelayMs + '}';
    }
}

