/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularitySlaveUsage;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="A description of resources used on a mesos slave")
public class SingularitySlaveUsageWithId
extends SingularitySlaveUsage {
    private final String slaveId;

    public SingularitySlaveUsageWithId(SingularitySlaveUsage usage, String slaveId) {
        super(usage.getCpusUsed(), usage.getCpusReserved(), usage.getCpusTotal(), usage.getMemoryBytesUsed(), usage.getMemoryMbReserved(), usage.getMemoryMbTotal(), usage.getDiskBytesUsed(), usage.getDiskMbReserved(), usage.getDiskMbTotal(), usage.getNumTasks(), usage.getTimestamp(), usage.getSystemMemTotalBytes(), usage.getSystemMemFreeBytes(), usage.getSystemCpusTotal(), usage.getSystemLoad1Min(), usage.getSystemLoad5Min(), usage.getSystemLoad15Min(), usage.getSlaveDiskUsed(), usage.getSlaveDiskTotal());
        this.slaveId = slaveId;
    }

    @JsonCreator
    public SingularitySlaveUsageWithId(@JsonProperty(value="cpusUsed") double cpusUsed, @JsonProperty(value="cpusReserved") double cpusReserved, @JsonProperty(value="cpusTotal") Optional<Double> cpusTotal, @JsonProperty(value="memoryBytesUsed") double memoryBytesUsed, @JsonProperty(value="memoryMbReserved") double memoryMbReserved, @JsonProperty(value="memoryMbTotal") Optional<Long> memoryMbTotal, @JsonProperty(value="diskBytesUsed") double diskBytesUsed, @JsonProperty(value="diskMbReserved") double diskMbReserved, @JsonProperty(value="diskMbTotal") Optional<Long> diskMbTotal, @JsonProperty(value="numTasks") int numTasks, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="systemMemTotalBytes") double systemMemTotalBytes, @JsonProperty(value="systemMemFreeBytes") double systemMemFreeBytes, @JsonProperty(value="systemCpusTotal") double systemCpusTotal, @JsonProperty(value="systemLoad1Min") double systemLoad1Min, @JsonProperty(value="systemLoad5Min") double systemLoad5Min, @JsonProperty(value="systemLoad15Min") double systemLoad15Min, @JsonProperty(value="slaveDiskUsed") double slaveDiskUsed, @JsonProperty(value="slaveDiskTotal") double slaveDiskTotal, @JsonProperty(value="slaveId") String slaveId) {
        super(cpusUsed, cpusReserved, cpusTotal, memoryBytesUsed, memoryMbReserved, memoryMbTotal, diskBytesUsed, diskMbReserved, diskMbTotal, numTasks, timestamp, systemMemTotalBytes, systemMemFreeBytes, systemCpusTotal, systemLoad1Min, systemLoad5Min, systemLoad15Min, slaveDiskUsed, slaveDiskTotal);
        this.slaveId = slaveId;
    }

    @Schema(description="The id as assigned by mesos for this particualr slave")
    public String getSlaveId() {
        return this.slaveId;
    }

    @Override
    public String toString() {
        return "SingularitySlaveUsageWithId [slaveId=" + this.slaveId + ", super=" + super.toString() + "]";
    }
}

