/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.json.MesosResourcesObject;
import com.hubspot.singularity.SingularityMachineAbstraction;
import com.hubspot.singularity.SingularityMachineStateHistoryUpdate;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@Schema(description="Singularity's view of a Mesos slave")
public class SingularitySlave
extends SingularityMachineAbstraction<SingularitySlave> {
    private final String host;
    private final String rackId;
    private final Map<String, String> attributes;
    private final Optional<MesosResourcesObject> resources;

    public SingularitySlave(String slaveId, String host, String rackId, Map<String, String> attributes, Optional<MesosResourcesObject> resources) {
        super(slaveId);
        this.host = host;
        this.rackId = rackId;
        this.attributes = attributes;
        this.resources = resources;
    }

    @JsonCreator
    public SingularitySlave(@JsonProperty(value="slaveId") String slaveId, @JsonProperty(value="firstSeenAt") long firstSeenAt, @JsonProperty(value="currentState") SingularityMachineStateHistoryUpdate currentState, @JsonProperty(value="host") String host, @JsonProperty(value="rackId") String rackId, @JsonProperty(value="attributes") Map<String, String> attributes, @JsonProperty(value="resources") Optional<MesosResourcesObject> resources) {
        super(slaveId, firstSeenAt, currentState);
        this.host = host;
        this.rackId = rackId;
        this.attributes = attributes;
        this.resources = resources;
    }

    @Override
    public SingularitySlave changeState(SingularityMachineStateHistoryUpdate newState) {
        return new SingularitySlave(this.getId(), this.getFirstSeenAt(), newState, this.host, this.rackId, this.attributes, this.resources);
    }

    @Schema(description="Slave hostname")
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return String.format("%s (%s)", this.getHost(), this.getId());
    }

    @Override
    @JsonIgnore
    public String getTypeName() {
        return "Slave";
    }

    @JsonIgnore
    public SingularitySlave withResources(MesosResourcesObject resources) {
        return new SingularitySlave(this.getId(), this.getFirstSeenAt(), this.getCurrentState(), this.host, this.rackId, this.attributes, Optional.of(resources));
    }

    @Schema(description="Slave rack ID")
    public String getRackId() {
        return this.rackId;
    }

    @Schema(description="Mesos attributes associated with this slave")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Schema(description="Resources available to allocate on this slave")
    public Optional<MesosResourcesObject> getResources() {
        return this.resources;
    }

    public String toString() {
        return "SingularitySlave{host='" + this.host + '\'' + ", rackId='" + this.rackId + '\'' + ", attributes=" + this.attributes + ", resources=" + this.resources + "} " + super.toString();
    }
}

