/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Describes a file that shouldbe uploaded by the SingularityS3Uploader")
public class SingularityS3UploaderFile {
    private final String filename;
    private final Optional<String> s3UploaderBucket;
    private final Optional<String> s3UploaderKeyPattern;
    private final Optional<String> s3UploaderFilenameHint;
    private final Optional<String> directory;
    private final Optional<String> s3StorageClass;
    private final Optional<Long> applyS3StorageClassAfterBytes;
    private final boolean checkSubdirectories;

    @JsonCreator
    public static SingularityS3UploaderFile fromString(String value) {
        return new SingularityS3UploaderFile(value, Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent());
    }

    @JsonCreator
    public SingularityS3UploaderFile(@JsonProperty(value="filename") String filename, @JsonProperty(value="s3UploaderBucket") Optional<String> s3UploaderBucket, @JsonProperty(value="s3UploaderKeyPattern") Optional<String> s3UploaderKeyPattern, @JsonProperty(value="s3UploaderFilenameHint") Optional<String> s3UploaderFilenameHint, @JsonProperty(value="directory") Optional<String> directory, @JsonProperty(value="s3StorageClass") Optional<String> s3StorageClass, @JsonProperty(value="applyS3StorageClassAfterBytes") Optional<Long> applyS3StorageClassAfterBytes, @JsonProperty(value="checkSubdirectories") Optional<Boolean> checkSubdirectories) {
        this.filename = filename;
        this.s3UploaderBucket = s3UploaderBucket;
        this.s3UploaderKeyPattern = s3UploaderKeyPattern;
        this.s3UploaderFilenameHint = s3UploaderFilenameHint;
        this.directory = directory;
        this.s3StorageClass = s3StorageClass;
        this.applyS3StorageClassAfterBytes = applyS3StorageClassAfterBytes;
        this.checkSubdirectories = checkSubdirectories.or(false);
    }

    @Schema(description="The name of the file")
    public String getFilename() {
        return this.filename;
    }

    @Schema(title="The s3 bucket to upload to", nullable=true, defaultValue="The default bucket configured in the S3Uploader")
    public Optional<String> getS3UploaderBucket() {
        return this.s3UploaderBucket;
    }

    @Schema(title="The pattern to use when generating the S3 key for the object that is uploaded", nullable=true, defaultValue="The default pattern configured in the S3Uploader")
    public Optional<String> getS3UploaderKeyPattern() {
        return this.s3UploaderKeyPattern;
    }

    @Schema(title="An optional suffix appended to the uploader metadata file for easier debugging", nullable=true)
    public Optional<String> getS3UploaderFilenameHint() {
        return this.s3UploaderFilenameHint;
    }

    @Schema(title="The directory to search for files to upload", nullable=true, defaultValue="The task sandbox directory")
    public Optional<String> getDirectory() {
        return this.directory;
    }

    @Schema(title="The aws storage class to use for files uploaded", nullable=true, defaultValue="The storage class as configured in the S3Uploader depending on file size")
    public Optional<String> getS3StorageClass() {
        return this.s3StorageClass;
    }

    @Schema(title="The size of file required in order to apply the `s3StorageClass` if present", nullable=true, defaultValue="`applyS3StorageClassAfterBytes` as configured in the S3Uploader")
    public Optional<Long> getApplyS3StorageClassAfterBytes() {
        return this.applyS3StorageClassAfterBytes;
    }

    @Schema(title="Recursively check directories for matching files", defaultValue="false")
    public boolean isCheckSubdirectories() {
        return this.checkSubdirectories;
    }

    public String toString() {
        return "SingularityS3UploaderFile{filename='" + this.filename + '\'' + ", s3UploaderBucket=" + this.s3UploaderBucket + ", s3UploaderKeyPattern=" + this.s3UploaderKeyPattern + ", s3UploaderFilenameHint=" + this.s3UploaderFilenameHint + ", directory=" + this.directory + ", s3StorageClass=" + this.s3StorageClass + ", applyS3StorageClassAfterBytes=" + this.applyS3StorageClassAfterBytes + ", checkSubdirectories=" + this.checkSubdirectories + '}';
    }
}

