/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.RequestState;
import com.hubspot.singularity.SingularityDeploy;
import com.hubspot.singularity.SingularityPendingDeploy;
import com.hubspot.singularity.SingularityRequest;
import com.hubspot.singularity.SingularityRequestDeployState;
import com.hubspot.singularity.SingularityTaskIdsByStatus;
import com.hubspot.singularity.expiring.SingularityExpiringBounce;
import com.hubspot.singularity.expiring.SingularityExpiringPause;
import com.hubspot.singularity.expiring.SingularityExpiringScale;
import com.hubspot.singularity.expiring.SingularityExpiringSkipHealthchecks;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Holds a SingularityRequest and its current state")
public class SingularityRequestParent {
    private final SingularityRequest request;
    private final RequestState state;
    private final Optional<SingularityRequestDeployState> requestDeployState;
    private final Optional<SingularityDeploy> activeDeploy;
    private final Optional<SingularityDeploy> pendingDeploy;
    private final Optional<SingularityPendingDeploy> pendingDeployState;
    private final Optional<SingularityExpiringBounce> expiringBounce;
    private final Optional<SingularityExpiringPause> expiringPause;
    private final Optional<SingularityExpiringScale> expiringScale;
    private final Optional<SingularityExpiringSkipHealthchecks> expiringSkipHealthchecks;
    private final Optional<SingularityTaskIdsByStatus> taskIds;

    public SingularityRequestParent(SingularityRequest request, RequestState state) {
        this(request, state, Optional.absent());
    }

    public SingularityRequestParent(SingularityRequest request, RequestState state, Optional<SingularityRequestDeployState> requestDeployState) {
        this(request, state, requestDeployState, Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent());
    }

    @JsonCreator
    public SingularityRequestParent(@JsonProperty(value="request") SingularityRequest request, @JsonProperty(value="state") RequestState state, @JsonProperty(value="requestDeployState") Optional<SingularityRequestDeployState> requestDeployState, @JsonProperty(value="activeDeploy") Optional<SingularityDeploy> activeDeploy, @JsonProperty(value="pendingDeploy") Optional<SingularityDeploy> pendingDeploy, @JsonProperty(value="pendingDeployState") Optional<SingularityPendingDeploy> pendingDeployState, @JsonProperty(value="expiringBounce") Optional<SingularityExpiringBounce> expiringBounce, @JsonProperty(value="expiringPause") Optional<SingularityExpiringPause> expiringPause, @JsonProperty(value="expiringScale") Optional<SingularityExpiringScale> expiringScale, @JsonProperty(value="expiringSkipHealthchecks") Optional<SingularityExpiringSkipHealthchecks> expiringSkipHealthchecks, @JsonProperty(value="taskIds") Optional<SingularityTaskIdsByStatus> taskIds) {
        this.request = request;
        this.state = state;
        this.requestDeployState = requestDeployState;
        this.activeDeploy = activeDeploy;
        this.pendingDeploy = pendingDeploy;
        this.pendingDeployState = pendingDeployState;
        this.expiringBounce = expiringBounce;
        this.expiringPause = expiringPause;
        this.expiringScale = expiringScale;
        this.expiringSkipHealthchecks = expiringSkipHealthchecks;
        this.taskIds = taskIds;
    }

    @Schema(description="Current state of the request")
    public RequestState getState() {
        return this.state;
    }

    @Schema(description="Full data for the request, a parent object for any deployed task")
    public SingularityRequest getRequest() {
        return this.request;
    }

    @Schema(description="Data about any active and/or pending deploys for this request", nullable=true)
    public Optional<SingularityRequestDeployState> getRequestDeployState() {
        return this.requestDeployState;
    }

    @Schema(description="Settings for the active deploy, may not contain the full deploy json", nullable=true)
    public Optional<SingularityDeploy> getActiveDeploy() {
        return this.activeDeploy;
    }

    @Schema(description="Settings for a pending/in-progress deploy, may not contain the full deploy json", nullable=true)
    public Optional<SingularityDeploy> getPendingDeploy() {
        return this.pendingDeploy;
    }

    @Schema(description="State of the pending deploy if one is present", nullable=true)
    public Optional<SingularityPendingDeploy> getPendingDeployState() {
        return this.pendingDeployState;
    }

    @Schema(description="Expiring bounce action details if one is active", nullable=true)
    public Optional<SingularityExpiringBounce> getExpiringBounce() {
        return this.expiringBounce;
    }

    @Schema(description="Details about an expiring pause if one is present", nullable=true)
    public Optional<SingularityExpiringPause> getExpiringPause() {
        return this.expiringPause;
    }

    @Schema(description="Details about a scale action that will eventually revert, if one is present", nullable=true)
    public Optional<SingularityExpiringScale> getExpiringScale() {
        return this.expiringScale;
    }

    @Schema(description="Details about a skip healthchecks action that will eventually revert", nullable=true)
    public Optional<SingularityExpiringSkipHealthchecks> getExpiringSkipHealthchecks() {
        return this.expiringSkipHealthchecks;
    }

    @Schema(description="A list of active and pending task ids, separated by status", nullable=true)
    public Optional<SingularityTaskIdsByStatus> getTaskIds() {
        return this.taskIds;
    }

    public String toString() {
        return "SingularityRequestParent{request=" + this.request + ", state=" + (Object)((Object)this.state) + ", requestDeployState=" + this.requestDeployState + ", activeDeploy=" + this.activeDeploy + ", pendingDeploy=" + this.pendingDeploy + ", pendingDeployState=" + this.pendingDeployState + ", expiringBounce=" + this.expiringBounce + ", expiringPause=" + this.expiringPause + ", expiringScale=" + this.expiringScale + ", expiringSkipHealthchecks=" + this.expiringSkipHealthchecks + ", taskIds=" + this.taskIds + '}';
    }
}

