/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.RequestCleanupType;
import com.hubspot.singularity.SingularityShellCommand;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Represents an action requiring tasks for a request to possibly be cleaned or replaced")
public class SingularityRequestCleanup {
    private final Optional<String> user;
    private final RequestCleanupType cleanupType;
    private final Optional<Boolean> killTasks;
    private final Optional<Boolean> removeFromLoadBalancer;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<String> deployId;
    private final long timestamp;
    private final String requestId;
    private final Optional<String> message;
    private final Optional<String> actionId;
    private final Optional<SingularityShellCommand> runShellCommandBeforeKill;

    @JsonCreator
    public SingularityRequestCleanup(@JsonProperty(value="user") Optional<String> user, @JsonProperty(value="cleanupType") RequestCleanupType cleanupType, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="killTasks") Optional<Boolean> killTasks, @JsonProperty(value="removeFromLoadBalancer") Optional<Boolean> removeFromLoadBalancer, @JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") Optional<String> deployId, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="actionId") Optional<String> actionId, @JsonProperty(value="runShellCommandBeforeKill") Optional<SingularityShellCommand> runShellCommandBeforeKill) {
        this.user = user;
        this.cleanupType = cleanupType;
        this.timestamp = timestamp;
        this.requestId = requestId;
        this.deployId = deployId;
        this.killTasks = killTasks;
        this.removeFromLoadBalancer = removeFromLoadBalancer;
        this.skipHealthchecks = skipHealthchecks;
        this.actionId = actionId;
        this.message = message;
        this.runShellCommandBeforeKill = runShellCommandBeforeKill;
    }

    @Schema(description="If `true`, skip health checks for new tasks created", nullable=true)
    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    @Schema(description="Override the system default behavior for immediately kiiling a task (relevant for pause-related cleanups)", nullable=true)
    public Optional<Boolean> getKillTasks() {
        return this.killTasks;
    }

    @Schema(description="For deletes, remove the service from the load balancer when all tasks are cleaned", nullable=true)
    public Optional<Boolean> getRemoveFromLoadBalancer() {
        return this.removeFromLoadBalancer;
    }

    @Schema(description="The request this cleanup relates to")
    public String getRequestId() {
        return this.requestId;
    }

    @Schema(description="The user that triggered this cleanup", nullable=true)
    public Optional<String> getUser() {
        return this.user;
    }

    @Schema(description="The type of cleanup")
    public RequestCleanupType getCleanupType() {
        return this.cleanupType;
    }

    @Schema(description="The time this cleanup was created")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="A specific deploy related to this cleanup", nullable=true)
    public Optional<String> getDeployId() {
        return this.deployId;
    }

    @Schema(description="An optional message stating the reason for this cleanup", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    @Schema(description="An optional unique id for this cleanup action", nullable=true)
    public Optional<String> getActionId() {
        return this.actionId;
    }

    @Schema(description="A shell command to run on tasks before they are killed", nullable=true)
    public Optional<SingularityShellCommand> getRunShellCommandBeforeKill() {
        return this.runShellCommandBeforeKill;
    }

    public String toString() {
        return "SingularityRequestCleanup{user=" + this.user + ", cleanupType=" + (Object)((Object)this.cleanupType) + ", killTasks=" + this.killTasks + ", removeFromLoadBalancer=" + this.removeFromLoadBalancer + ", skipHealthchecks=" + this.skipHealthchecks + ", deployId=" + this.deployId + ", timestamp=" + this.timestamp + ", requestId='" + this.requestId + '\'' + ", message=" + this.message + ", actionId=" + this.actionId + ", runShellCommandBeforeKill=" + this.runShellCommandBeforeKill + '}';
    }
}

