/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityRequestParent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Set;

@Schema(description="Batch response for multiple requests")
public class SingularityRequestBatch {
    private final List<SingularityRequestParent> requests;
    private final Set<String> notFound;

    @JsonCreator
    public SingularityRequestBatch(@JsonProperty(value="requests") List<SingularityRequestParent> requests, @JsonProperty(value="notFound") Set<String> notFound) {
        this.requests = requests;
        this.notFound = notFound;
    }

    @Schema(nullable=false, description="List of found reqeusts from the batch")
    public List<SingularityRequestParent> getRequests() {
        return this.requests;
    }

    @Schema(nullable=false, description="List of request ids from the requested batch that were not found")
    public Set<String> getNotFound() {
        return this.notFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityRequestBatch that = (SingularityRequestBatch)o;
        if (this.requests != null ? !this.requests.equals(that.requests) : that.requests != null) {
            return false;
        }
        return this.notFound != null ? this.notFound.equals(that.notFound) : that.notFound == null;
    }

    public int hashCode() {
        int result = this.requests != null ? this.requests.hashCode() : 0;
        result = 31 * result + (this.notFound != null ? this.notFound.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SingularityRequestBatch{requests=" + this.requests + ", notFound=" + this.notFound + '}';
    }
}

