/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.RequestCleanupType;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.TaskCleanupType;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Describes a task that has been sent a kill signal")
public class SingularityKilledTaskIdRecord {
    private final SingularityTaskId taskId;
    private final long originalTimestamp;
    private final long timestamp;
    private final Optional<RequestCleanupType> requestCleanupType;
    private final Optional<TaskCleanupType> taskCleanupType;
    private final int retries;

    @JsonCreator
    public SingularityKilledTaskIdRecord(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="originalTimestamp") long originalTimestamp, @JsonProperty(value="requestCleanupType") Optional<RequestCleanupType> requestCleanupType, @JsonProperty(value="taskCleanupType") Optional<TaskCleanupType> taskCleanupType, @JsonProperty(value="retries") int retries) {
        this.taskId = taskId;
        this.timestamp = timestamp;
        this.requestCleanupType = requestCleanupType;
        this.taskCleanupType = taskCleanupType;
        this.retries = retries;
        this.originalTimestamp = originalTimestamp;
    }

    @Schema(description="The unique id of the task")
    public SingularityTaskId getTaskId() {
        return this.taskId;
    }

    @Schema(description="the time at which the signal was triggered")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="An optional enum cleanup type associated with this task kill", nullable=true)
    public Optional<RequestCleanupType> getRequestCleanupType() {
        return this.requestCleanupType;
    }

    @Schema(description="An optional enum cleanup type associated with this task kill", nullable=true)
    public Optional<TaskCleanupType> getTaskCleanupType() {
        return this.taskCleanupType;
    }

    @Schema(description="The original time when the task kill was triggered (in case multiple kills have been issued)")
    public long getOriginalTimestamp() {
        return this.originalTimestamp;
    }

    @Schema(description="The number of attempts to kill this task so far")
    public int getRetries() {
        return this.retries;
    }

    public String toString() {
        return "SingularityKilledTaskIdRecord{taskId=" + this.taskId + ", originalTimestamp=" + this.originalTimestamp + ", timestamp=" + this.timestamp + ", requestCleanupType=" + this.requestCleanupType + ", taskCleanupType=" + this.taskCleanupType + ", retries=" + this.retries + '}';
    }
}

