/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityDeploy;
import com.hubspot.singularity.SingularityDeployMarker;
import com.hubspot.singularity.SingularityDeployResult;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="A webhook event representing an update to deploy data")
public class SingularityDeployUpdate {
    private final SingularityDeployMarker deployMarker;
    private final Optional<SingularityDeploy> deploy;
    private final DeployEventType eventType;
    private final Optional<SingularityDeployResult> deployResult;

    @JsonCreator
    public SingularityDeployUpdate(@JsonProperty(value="deployMarker") SingularityDeployMarker deployMarker, @JsonProperty(value="deploy") Optional<SingularityDeploy> deploy, @JsonProperty(value="eventType") DeployEventType eventType, @JsonProperty(value="deployResult") Optional<SingularityDeployResult> deployResult) {
        this.deployMarker = deployMarker;
        this.deploy = deploy;
        this.eventType = eventType;
        this.deployResult = deployResult;
    }

    @Schema(description="An object identifying a particular deploy for a request")
    public SingularityDeployMarker getDeployMarker() {
        return this.deployMarker;
    }

    @Schema(description="The full data of the deploy", nullable=true)
    public Optional<SingularityDeploy> getDeploy() {
        return this.deploy;
    }

    @Schema(description="Starting or Finished")
    public DeployEventType getEventType() {
        return this.eventType;
    }

    @Schema(description="The result of the deploy if it has finished", nullable=true)
    public Optional<SingularityDeployResult> getDeployResult() {
        return this.deployResult;
    }

    public String toString() {
        return "SingularityDeployUpdate{deployMarker=" + this.deployMarker + ", deploy=" + this.deploy + ", eventType=" + (Object)((Object)this.eventType) + ", deployResult=" + this.deployResult + '}';
    }

    @Schema
    public static enum DeployEventType {
        STARTING,
        FINISHED;

    }
}

