/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityDeployStatisticsBuilder;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Task statistics related to a particular deploy")
public class SingularityDeployStatistics {
    private final String requestId;
    private final String deployId;
    private final int numTasks;
    private final int numSuccess;
    private final int numFailures;
    private final int numSequentialRetries;
    private final ListMultimap<Integer, Long> instanceSequentialFailureTimestamps;
    private final Optional<Long> lastFinishAt;
    private final Optional<ExtendedTaskState> lastTaskState;
    private final Optional<Long> averageRuntimeMillis;
    private final Optional<Long> averageSchedulingDelayMillis;

    @JsonCreator
    public SingularityDeployStatistics(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="numSuccess") int numSuccess, @JsonProperty(value="numFailures") int numFailures, @JsonProperty(value="numSequentialRetries") int numSequentialRetries, @JsonProperty(value="lastFinishAt") Optional<Long> lastFinishAt, @JsonProperty(value="lastTaskState") Optional<ExtendedTaskState> lastTaskState, @JsonProperty(value="instanceSequentialFailureTimestamps") ListMultimap<Integer, Long> instanceSequentialFailureTimestamps, @JsonProperty(value="numTasks") int numTasks, @JsonProperty(value="averageRuntimeMillis") Optional<Long> averageRuntimeMillis, @JsonProperty(value="averageSchedulingDelayMillis") Optional<Long> averageSchedulingDelayMillis) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.numSuccess = numSuccess;
        this.numFailures = numFailures;
        this.lastFinishAt = lastFinishAt;
        this.lastTaskState = lastTaskState;
        this.numSequentialRetries = numSequentialRetries;
        this.numTasks = numTasks;
        this.averageRuntimeMillis = averageRuntimeMillis;
        this.averageSchedulingDelayMillis = averageSchedulingDelayMillis;
        this.instanceSequentialFailureTimestamps = instanceSequentialFailureTimestamps == null ? ImmutableListMultimap.of() : ImmutableListMultimap.copyOf(instanceSequentialFailureTimestamps);
    }

    public SingularityDeployStatisticsBuilder toBuilder() {
        return new SingularityDeployStatisticsBuilder(this.requestId, this.deployId).setLastFinishAt(this.lastFinishAt).setLastTaskState(this.lastTaskState).setNumSequentialRetries(this.numSequentialRetries).setNumFailures(this.numFailures).setNumSuccess(this.numSuccess).setNumTasks(this.numTasks).setAverageRuntimeMillis(this.averageRuntimeMillis).setAverageSchedulingDelayMillis(this.averageSchedulingDelayMillis).setInstanceSequentialFailureTimestamps(ArrayListMultimap.create(this.instanceSequentialFailureTimestamps));
    }

    @Schema(description="The number of tasks associated with this deploy")
    public int getNumTasks() {
        return this.numTasks;
    }

    @Schema(description="Average runtime of tasks associated with this deploy", nullable=true)
    public Optional<Long> getAverageRuntimeMillis() {
        return this.averageRuntimeMillis;
    }

    @Schema(description="Average delay launching tasks for this deploy", nullable=true)
    public Optional<Long> getAverageSchedulingDelayMillis() {
        return this.averageSchedulingDelayMillis;
    }

    @Schema(description="Request id")
    public String getRequestId() {
        return this.requestId;
    }

    @Schema(description="Deploy id")
    public String getDeployId() {
        return this.deployId;
    }

    @Schema(description="Number of sequential successful tasks (used in cooldown calculations)")
    public int getNumSuccess() {
        return this.numSuccess;
    }

    @Schema(description="Number of sequential failed tasks (used in cooldown calculations)")
    public int getNumFailures() {
        return this.numFailures;
    }

    @Schema(description="Time of the last finished task for this deploy", nullable=true)
    public Optional<Long> getLastFinishAt() {
        return this.lastFinishAt;
    }

    @Schema(description="The most recent task state for this deploy", nullable=true)
    public Optional<ExtendedTaskState> getLastTaskState() {
        return this.lastTaskState;
    }

    @Schema(description="Number of retries for tasks in this deploy, relevant for scheduled request types")
    public int getNumSequentialRetries() {
        return this.numSequentialRetries;
    }

    @Schema(description="Timestamps of failed tasks by instance number")
    public ListMultimap<Integer, Long> getInstanceSequentialFailureTimestamps() {
        return this.instanceSequentialFailureTimestamps;
    }

    public String toString() {
        return "SingularityDeployStatistics{requestId='" + this.requestId + '\'' + ", deployId='" + this.deployId + '\'' + ", numTasks=" + this.numTasks + ", numSuccess=" + this.numSuccess + ", numFailures=" + this.numFailures + ", numSequentialRetries=" + this.numSequentialRetries + ", instanceSequentialFailureTimestamps=" + this.instanceSequentialFailureTimestamps + ", lastFinishAt=" + this.lastFinishAt + ", lastTaskState=" + this.lastTaskState + ", averageRuntimeMillis=" + this.averageRuntimeMillis + ", averageSchedulingDelayMillis=" + this.averageSchedulingDelayMillis + '}';
    }
}

