/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.DeployState;
import com.hubspot.singularity.SingularityDeployFailure;
import com.hubspot.singularity.SingularityLoadBalancerUpdate;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;

@Schema(description="The result of a deploy for a particular request")
public class SingularityDeployResult {
    private final DeployState deployState;
    private final Optional<SingularityLoadBalancerUpdate> lbUpdate;
    private final Optional<String> message;
    private final List<SingularityDeployFailure> deployFailures;
    private final long timestamp;

    public SingularityDeployResult(DeployState deployState) {
        this(deployState, Optional.absent(), Optional.absent(), Collections.emptyList(), System.currentTimeMillis());
    }

    public SingularityDeployResult(DeployState deployState, String message) {
        this(deployState, Optional.of(message), Optional.absent(), Collections.emptyList(), System.currentTimeMillis());
    }

    public SingularityDeployResult(DeployState deployState, Optional<String> message, Optional<SingularityLoadBalancerUpdate> lbUpdate) {
        this(deployState, message, lbUpdate, Collections.emptyList(), System.currentTimeMillis());
    }

    public SingularityDeployResult(DeployState deployState, SingularityLoadBalancerUpdate lbUpdate, List<SingularityDeployFailure> deployFailures) {
        this(deployState, Optional.of(String.format("Load balancer had state %s%s", new Object[]{lbUpdate.getLoadBalancerState(), lbUpdate.getMessage().isPresent() && lbUpdate.getMessage().get().length() > 0 ? String.format(" (%s)", lbUpdate.getMessage().get()) : ""})), Optional.of(lbUpdate), deployFailures, System.currentTimeMillis());
    }

    @JsonCreator
    public SingularityDeployResult(@JsonProperty(value="deployState") DeployState deployState, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="lbUpdate") Optional<SingularityLoadBalancerUpdate> lbUpdate, @JsonProperty(value="deployFailures") List<SingularityDeployFailure> deployFailures, @JsonProperty(value="timestamp") long timestamp) {
        this.deployState = deployState;
        this.lbUpdate = lbUpdate;
        this.message = message;
        this.deployFailures = deployFailures != null ? deployFailures : Collections.emptyList();
        this.timestamp = timestamp;
    }

    @Schema(description="The result of the load balancer update, if one occured, for a load balanced request", nullable=true)
    public Optional<SingularityLoadBalancerUpdate> getLbUpdate() {
        return this.lbUpdate;
    }

    @Schema(description="An optional message accompanying the deploy result", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    @Schema(description="The current state of the deploy")
    public DeployState getDeployState() {
        return this.deployState;
    }

    @Schema(description="Details about a failed deploy", nullable=true)
    public List<SingularityDeployFailure> getDeployFailures() {
        return this.deployFailures;
    }

    @Schema(description="The time of this deploy update")
    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "SingularityDeployResult{deployState=" + (Object)((Object)this.deployState) + ", lbUpdate=" + this.lbUpdate + ", message=" + this.message + ", deployFailures=" + this.deployFailures + ", timestamp=" + this.timestamp + '}';
    }
}

